/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SemaphoreAcquireCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreAvailablePermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreDrainPermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreInitCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreReducePermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreReleaseCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreTryAcquireCodec;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.nio.serialization.Data;
import java.util.concurrent.TimeUnit;

public class ClientSemaphoreProxy
extends ClientProxy
implements ISemaphore {
    private final String name;
    private volatile Data key;

    public ClientSemaphoreProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    public boolean init(int permits) {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreInitCodec.encodeRequest((String)this.name, (int)permits);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SemaphoreInitCodec.ResponseParameters resultParameters = SemaphoreInitCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void acquire() throws InterruptedException {
        ClientMessage request = SemaphoreAcquireCodec.encodeRequest((String)this.name, (int)1);
        this.invoke(request);
    }

    public void acquire(int permits) throws InterruptedException {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreAcquireCodec.encodeRequest((String)this.name, (int)permits);
        this.invoke(request);
    }

    public int availablePermits() {
        ClientMessage request = SemaphoreAvailablePermitsCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SemaphoreAvailablePermitsCodec.ResponseParameters resultParameters = SemaphoreAvailablePermitsCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public int drainPermits() {
        ClientMessage request = SemaphoreDrainPermitsCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SemaphoreDrainPermitsCodec.ResponseParameters resultParameters = SemaphoreDrainPermitsCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void reducePermits(int reduction) {
        this.checkNegative(reduction);
        ClientMessage request = SemaphoreReducePermitsCodec.encodeRequest((String)this.name, (int)reduction);
        this.invoke(request);
    }

    public void release() {
        ClientMessage request = SemaphoreReleaseCodec.encodeRequest((String)this.name, (int)1);
        this.invoke(request);
    }

    public void release(int permits) {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreReleaseCodec.encodeRequest((String)this.name, (int)permits);
        this.invoke(request);
    }

    public boolean tryAcquire() {
        ClientMessage request = SemaphoreTryAcquireCodec.encodeRequest((String)this.name, (int)1, (long)0L);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SemaphoreTryAcquireCodec.ResponseParameters resultParameters = SemaphoreTryAcquireCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean tryAcquire(int permits) {
        this.checkNegative(permits);
        try {
            return this.tryAcquire(permits, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout == 0L) {
            return this.tryAcquire();
        }
        ClientMessage request = SemaphoreTryAcquireCodec.encodeRequest((String)this.name, (int)1, (long)unit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invoke(request);
        SemaphoreTryAcquireCodec.ResponseParameters resultParameters = SemaphoreTryAcquireCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreTryAcquireCodec.encodeRequest((String)this.name, (int)permits, (long)unit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invoke(request);
        SemaphoreTryAcquireCodec.ResponseParameters resultParameters = SemaphoreTryAcquireCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getKey());
    }

    public Data getKey() {
        if (this.key == null) {
            this.key = this.getContext().getSerializationService().toData((Object)this.name);
        }
        return this.key;
    }

    private void checkNegative(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits cannot be negative!");
        }
    }

    public String toString() {
        return "ISemaphore{name='" + this.getName() + '\'' + '}';
    }
}

