/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.ExecutorServiceCancelOnAddressParameters;
import com.hazelcast.client.impl.protocol.parameters.ExecutorServiceCancelOnPartitionParameters;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ClientCancellableDelegatingFuture<V>
extends DelegatingFuture<V> {
    private static final int INVOCATION_WAIT_TIMEOUT_SECONDS = 5;
    private final ClientContext context;
    private final String uuid;
    private final Address target;
    private final int partitionId;
    private final ILogger logger = Logger.getLogger(ClientCancellableDelegatingFuture.class);
    private volatile boolean cancelled;

    public ClientCancellableDelegatingFuture(ICompletableFuture future, ClientContext context, String uuid, Address target, int partitionId, V defaultValue) {
        super(future, context.getSerializationService(), defaultValue);
        this.context = context;
        this.uuid = uuid;
        this.target = target;
        this.partitionId = partitionId;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone() || this.cancelled) {
            return false;
        }
        this.waitForRequestToBeSend();
        Future<ClientMessage> f = this.invokeCancelRequest(mayInterruptIfRunning);
        try {
            Boolean b = BooleanResultParameters.decode((ClientMessage)f.get()).result;
            if (b != null && b.booleanValue()) {
                this.setError(new CancellationException());
                this.cancelled = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            this.setDone();
        }
    }

    private Future<ClientMessage> invokeCancelRequest(boolean mayInterruptIfRunning) {
        ClientInvocation clientInvocation;
        ClientMessage request;
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        if (this.target != null) {
            request = ExecutorServiceCancelOnAddressParameters.encode((String)this.uuid, (String)this.target.getHost(), (int)this.target.getPort(), (boolean)mayInterruptIfRunning);
            clientInvocation = new ClientInvocation(client, request, this.target);
        } else {
            request = ExecutorServiceCancelOnPartitionParameters.encode((String)this.uuid, (int)this.partitionId, (boolean)mayInterruptIfRunning);
            clientInvocation = new ClientInvocation(client, request, this.partitionId);
        }
        try {
            return clientInvocation.invoke();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private void waitForRequestToBeSend() {
        ICompletableFuture future = this.getFuture();
        ClientInvocationFuture clientCallFuture = (ClientInvocationFuture)future;
        ClientInvocation invocation = clientCallFuture.getInvocation();
        int timeoutSeconds = 5;
        while (!invocation.isInvoked()) {
            if (timeoutSeconds-- == 0) {
                this.logger.warning("Cancel is failed because runnable/callable never send to remote !");
                break;
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

