/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalSetAddParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalSetRemoveParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalSetSizeParameters;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.client.txn.proxy.AbstractClientTxnCollectionProxy;
import com.hazelcast.core.TransactionalSet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ThreadUtil;

public class ClientTxnSetProxy<E>
extends AbstractClientTxnCollectionProxy<E>
implements TransactionalSet<E> {
    public ClientTxnSetProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    public boolean add(E e) {
        this.throwExceptionIfNull(e);
        Data value = this.toData(e);
        ClientMessage request = TransactionalSetAddParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)value);
        ClientMessage response = this.invoke(request);
        return BooleanResultParameters.decode((ClientMessage)response).result;
    }

    public boolean remove(E e) {
        this.throwExceptionIfNull(e);
        Data value = this.toData(e);
        ClientMessage request = TransactionalSetRemoveParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)value);
        ClientMessage response = this.invoke(request);
        return BooleanResultParameters.decode((ClientMessage)response).result;
    }

    public int size() {
        ClientMessage request = TransactionalSetSizeParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        return IntResultParameters.decode((ClientMessage)response).result;
    }

    public String getServiceName() {
        return "hz:impl:setService";
    }
}

