/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.GenericResultParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalQueueOfferParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalQueuePeekParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalQueuePollParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalQueueSizeParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalQueueTakeParameters;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.client.txn.proxy.ClientTxnProxy;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ThreadUtil;
import java.util.concurrent.TimeUnit;

public class ClientTxnQueueProxy<E>
extends ClientTxnProxy
implements TransactionalQueue<E> {
    public ClientTxnQueueProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    public boolean offer(E e) {
        try {
            return this.offer(e, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e1) {
            return false;
        }
    }

    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Data data = this.toData(e);
        ClientMessage request = TransactionalQueueOfferParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)data, (long)unit.toMillis(timeout));
        ClientMessage response = this.invoke(request);
        BooleanResultParameters result = BooleanResultParameters.decode((ClientMessage)response);
        return result.result;
    }

    public E take() throws InterruptedException {
        ClientMessage request = TransactionalQueueTakeParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        GenericResultParameters result = GenericResultParameters.decode((ClientMessage)response);
        return (E)this.toObject(result.result);
    }

    public E poll() {
        try {
            return this.poll(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        ClientMessage request = TransactionalQueuePollParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (long)unit.toMillis(timeout));
        ClientMessage response = this.invoke(request);
        GenericResultParameters result = GenericResultParameters.decode((ClientMessage)response);
        return (E)this.toObject(result.result);
    }

    public E peek() {
        try {
            return this.peek(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public E peek(long timeout, TimeUnit unit) throws InterruptedException {
        ClientMessage request = TransactionalQueuePeekParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (long)unit.toMillis(timeout));
        ClientMessage response = this.invoke(request);
        GenericResultParameters result = GenericResultParameters.decode((ClientMessage)response);
        return (E)this.toObject(result.result);
    }

    public int size() {
        ClientMessage request = TransactionalQueueSizeParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        IntResultParameters result = IntResultParameters.decode((ClientMessage)response);
        return result.result;
    }

    public String getName() {
        return (String)this.getId();
    }

    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    void onDestroy() {
    }
}

