/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.DataCollectionResultParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMultiMapGetParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMultiMapPutParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMultiMapRemoveEntryParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMultiMapRemoveParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMultiMapSizeParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMultiMapValueCountParameters;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.client.txn.proxy.ClientTxnProxy;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.util.ThreadUtil;
import java.util.ArrayList;
import java.util.Collection;

public class ClientTxnMultiMapProxy<K, V>
extends ClientTxnProxy
implements TransactionalMultiMap<K, V> {
    public ClientTxnMultiMapProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    public boolean put(K key, V value) throws TransactionException {
        ClientMessage request = TransactionalMultiMapPutParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value));
        ClientMessage response = this.invoke(request);
        return BooleanResultParameters.decode((ClientMessage)response).result;
    }

    public Collection<V> get(K key) {
        ClientMessage request = TransactionalMultiMapGetParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection collection = resultParameters.result;
        ArrayList<Object> coll = new ArrayList<Object>(collection.size());
        for (Data data : collection) {
            coll.add(this.toObject(data));
        }
        return coll;
    }

    public boolean remove(Object key, Object value) {
        ClientMessage request = TransactionalMultiMapRemoveEntryParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value));
        ClientMessage response = this.invoke(request);
        return BooleanResultParameters.decode((ClientMessage)response).result;
    }

    public Collection<V> remove(Object key) {
        ClientMessage request = TransactionalMultiMapRemoveParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection collection = resultParameters.result;
        ArrayList<Object> coll = new ArrayList<Object>(collection.size());
        for (Data data : collection) {
            coll.add(this.toObject(data));
        }
        return coll;
    }

    public int valueCount(K key) {
        ClientMessage request = TransactionalMultiMapValueCountParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        return IntResultParameters.decode((ClientMessage)response).result;
    }

    public int size() {
        ClientMessage request = TransactionalMultiMapSizeParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        return IntResultParameters.decode((ClientMessage)response).result;
    }

    public String getName() {
        return (String)this.getId();
    }

    public String getServiceName() {
        return "hz:impl:multiMapService";
    }

    @Override
    void onDestroy() {
    }
}

