/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.DataCollectionResultParameters;
import com.hazelcast.client.impl.protocol.parameters.GenericResultParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapContainsKeyParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapDeleteParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapGetForUpdateParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapGetParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapKeySetParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapKeySetWithPredicateParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapPutIfAbsentParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapPutParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapRemoveIfSameParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapRemoveParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapReplaceIfSameParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapReplaceParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapSetParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapSizeParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapValuesParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalMapValuesWithPredicateParameters;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.client.txn.proxy.ClientTxnProxy;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.ThreadUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientTxnMapProxy<K, V>
extends ClientTxnProxy
implements TransactionalMap<K, V> {
    public ClientTxnMapProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    public boolean containsKey(Object key) {
        ClientMessage request = TransactionalMapContainsKeyParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        return BooleanResultParameters.decode((ClientMessage)response).result;
    }

    public V get(Object key) {
        ClientMessage request = TransactionalMapGetParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(GenericResultParameters.decode((ClientMessage)response).result);
    }

    public V getForUpdate(Object key) {
        ClientMessage request = TransactionalMapGetForUpdateParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(GenericResultParameters.decode((ClientMessage)response).result);
    }

    public int size() {
        ClientMessage request = TransactionalMapSizeParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        return IntResultParameters.decode((ClientMessage)response).result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public V put(K key, V value) {
        return this.put(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        ClientMessage request = TransactionalMapPutParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value), (long)timeunit.toMillis(ttl));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(GenericResultParameters.decode((ClientMessage)response).result);
    }

    public void set(K key, V value) {
        ClientMessage request = TransactionalMapSetParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value));
        this.invoke(request);
    }

    public V putIfAbsent(K key, V value) {
        ClientMessage request = TransactionalMapPutIfAbsentParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(GenericResultParameters.decode((ClientMessage)response).result);
    }

    public V replace(K key, V value) {
        ClientMessage request = TransactionalMapReplaceParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(GenericResultParameters.decode((ClientMessage)response).result);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        ClientMessage request = TransactionalMapReplaceIfSameParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(oldValue), (Data)this.toData(newValue));
        ClientMessage response = this.invoke(request);
        return BooleanResultParameters.decode((ClientMessage)response).result;
    }

    public V remove(Object key) {
        ClientMessage request = TransactionalMapRemoveParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(GenericResultParameters.decode((ClientMessage)response).result);
    }

    public void delete(Object key) {
        ClientMessage request = TransactionalMapDeleteParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key));
        this.invoke(request);
    }

    public boolean remove(Object key, Object value) {
        ClientMessage request = TransactionalMapRemoveIfSameParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(key), (Data)this.toData(value));
        ClientMessage response = this.invoke(request);
        return BooleanResultParameters.decode((ClientMessage)response).result;
    }

    public Set<K> keySet() {
        ClientMessage request = TransactionalMapKeySetParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        Collection dataKeySet = DataCollectionResultParameters.decode((ClientMessage)response).result;
        HashSet<Object> keySet = new HashSet<Object>(dataKeySet.size());
        for (Data data : dataKeySet) {
            keySet.add(this.toObject(data));
        }
        return keySet;
    }

    public Set<K> keySet(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        ClientMessage request = TransactionalMapKeySetWithPredicateParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(predicate));
        ClientMessage response = this.invoke(request);
        Collection dataKeySet = DataCollectionResultParameters.decode((ClientMessage)response).result;
        HashSet<Object> keySet = new HashSet<Object>(dataKeySet.size());
        for (Data data : dataKeySet) {
            keySet.add(this.toObject(data));
        }
        return keySet;
    }

    public Collection<V> values() {
        ClientMessage request = TransactionalMapValuesParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        Collection dataValues = DataCollectionResultParameters.decode((ClientMessage)response).result;
        HashSet<Object> values = new HashSet<Object>(dataValues.size());
        for (Data value : dataValues) {
            values.add(this.toObject(value));
        }
        return values;
    }

    public Collection<V> values(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        ClientMessage request = TransactionalMapValuesWithPredicateParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)this.toData(predicate));
        ClientMessage response = this.invoke(request);
        Collection dataValues = DataCollectionResultParameters.decode((ClientMessage)response).result;
        HashSet<Object> values = new HashSet<Object>(dataValues.size());
        for (Data value : dataValues) {
            values.add(this.toObject(value));
        }
        return values;
    }

    public String getName() {
        return (String)this.getId();
    }

    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    void onDestroy() {
    }
}

