/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalListAddParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalListRemoveParameters;
import com.hazelcast.client.impl.protocol.parameters.TransactionalListSizeParameters;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.client.txn.proxy.AbstractClientTxnCollectionProxy;
import com.hazelcast.core.TransactionalList;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ThreadUtil;

public class ClientTxnListProxy<E>
extends AbstractClientTxnCollectionProxy<E>
implements TransactionalList<E> {
    public ClientTxnListProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    public String getServiceName() {
        return "hz:impl:listService";
    }

    public boolean add(E e) {
        this.throwExceptionIfNull(e);
        Data value = this.toData(e);
        ClientMessage request = TransactionalListAddParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)value);
        ClientMessage response = this.invoke(request);
        return BooleanResultParameters.decode((ClientMessage)response).result;
    }

    public boolean remove(E e) {
        this.throwExceptionIfNull(e);
        Data value = this.toData(e);
        ClientMessage request = TransactionalListRemoveParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId(), (Data)value);
        ClientMessage response = this.invoke(request);
        return BooleanResultParameters.decode((ClientMessage)response).result;
    }

    public int size() {
        ClientMessage request = TransactionalListSizeParameters.encode((String)this.getName(), (String)this.getTransactionId(), (long)ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        return IntResultParameters.decode((ClientMessage)response).result;
    }
}

