/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.Authenticator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.LifecycleServiceImpl;
import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.AuthenticationCustomCredentialsParameters;
import com.hazelcast.client.impl.protocol.parameters.AuthenticationParameters;
import com.hazelcast.client.impl.protocol.parameters.AuthenticationResultParameters;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.impl.AwsAddressProvider;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.ClientMembershipListener;
import com.hazelcast.client.spi.impl.ConnectionHeartbeatListener;
import com.hazelcast.client.spi.impl.DefaultAddressProvider;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;

public abstract class ClusterListenerSupport
implements ConnectionListener,
ConnectionHeartbeatListener,
ClientClusterService {
    private static final ILogger LOGGER = Logger.getLogger(ClusterListenerSupport.class);
    protected final HazelcastClientInstanceImpl client;
    private final Collection<AddressProvider> addressProviders;
    private final ManagerAuthenticator managerAuthenticator = new ManagerAuthenticator();
    private final boolean shuffleMemberList;
    private Credentials credentials;
    private ClientConnectionManager connectionManager;
    private ClientListenerServiceImpl clientListenerService;
    private ClientMembershipListener clientMembershipListener;
    private volatile Address ownerConnectionAddress;
    private volatile ClientPrincipal principal;

    public ClusterListenerSupport(HazelcastClientInstanceImpl client) {
        this.client = client;
        ClientNetworkConfig networkConfig = client.getClientConfig().getNetworkConfig();
        ClientAwsConfig awsConfig = networkConfig.getAwsConfig();
        this.addressProviders = new LinkedList<AddressProvider>();
        this.addressProviders.add(new DefaultAddressProvider(networkConfig));
        if (awsConfig != null && awsConfig.isEnabled()) {
            try {
                this.addressProviders.add(new AwsAddressProvider(awsConfig));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.WARNING, "hazelcast-cloud.jar might be missing!");
                throw e;
            }
        }
        this.shuffleMemberList = client.getClientProperties().getShuffleMemberList().getBoolean();
    }

    protected void init() {
        this.connectionManager = this.client.getConnectionManager();
        this.clientListenerService = (ClientListenerServiceImpl)this.client.getListenerService();
        this.clientMembershipListener = new ClientMembershipListener(this.client);
        this.connectionManager.addConnectionListener(this);
        this.connectionManager.addConnectionHeartbeatListener(this);
        this.credentials = this.client.getCredentials();
    }

    @Override
    public Address getOwnerConnectionAddress() {
        return this.ownerConnectionAddress;
    }

    protected void connectToCluster() throws Exception {
        this.connectToOne();
        this.clientMembershipListener.listenMembershipEvents(this.ownerConnectionAddress);
        this.clientListenerService.triggerFailedListeners();
    }

    private Collection<InetSocketAddress> getSocketAddresses() {
        LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
        Collection memberList = this.getMemberList();
        for (MemberImpl member : memberList) {
            socketAddresses.add(member.getInetSocketAddress());
        }
        for (AddressProvider addressProvider : this.addressProviders) {
            socketAddresses.addAll(addressProvider.loadAddresses());
        }
        if (this.shuffleMemberList) {
            Collections.shuffle(socketAddresses);
        }
        return socketAddresses;
    }

    public ClientPrincipal getPrincipal() {
        return this.principal;
    }

    private void connectToOne() throws Exception {
        ClientNetworkConfig networkConfig = this.client.getClientConfig().getNetworkConfig();
        int connAttemptLimit = networkConfig.getConnectionAttemptLimit();
        int connectionAttemptPeriod = networkConfig.getConnectionAttemptPeriod();
        int connectionAttemptLimit = connAttemptLimit == 0 ? Integer.MAX_VALUE : connAttemptLimit;
        HashSet<InetSocketAddress> triedAddresses = new HashSet<InetSocketAddress>();
        for (int attempt = 0; attempt < connectionAttemptLimit; ++attempt) {
            if (!this.client.getLifecycleService().isRunning()) {
                if (!LOGGER.isFinestEnabled()) break;
                LOGGER.finest("Giving up on retrying to connect to cluster since client is shutdown");
                break;
            }
            long nextTry = Clock.currentTimeMillis() + (long)connectionAttemptPeriod;
            boolean isConnected = this.connect(triedAddresses);
            if (isConnected) {
                return;
            }
            long remainingTime = nextTry - Clock.currentTimeMillis();
            LOGGER.warning(String.format("Unable to get alive cluster connection, try in %d ms later, attempt %d of %d.", Math.max(0L, remainingTime), attempt, connectionAttemptLimit));
            if (remainingTime <= 0L) continue;
            try {
                Thread.sleep(remainingTime);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        throw new IllegalStateException("Unable to connect to any address in the config! The following addresses were tried:" + triedAddresses);
    }

    private boolean connect(Set<InetSocketAddress> triedAddresses) throws Exception {
        Collection<InetSocketAddress> socketAddresses = this.getSocketAddresses();
        for (InetSocketAddress inetSocketAddress : socketAddresses) {
            try {
                triedAddresses.add(inetSocketAddress);
                Address address = new Address(inetSocketAddress);
                if (LOGGER.isFinestEnabled()) {
                    LOGGER.finest("Trying to connect to " + address);
                }
                Connection connection = this.connectionManager.getOrConnect(address, this.managerAuthenticator);
                this.fireConnectionEvent(LifecycleEvent.LifecycleState.CLIENT_CONNECTED);
                this.ownerConnectionAddress = connection.getEndPoint();
                return true;
            }
            catch (Exception e) {
                Level level = e instanceof AuthenticationException ? Level.WARNING : Level.FINEST;
                LOGGER.log(level, "Exception during initial connection to " + inetSocketAddress, (Throwable)e);
            }
        }
        return false;
    }

    private void fireConnectionEvent(LifecycleEvent.LifecycleState state) {
        LifecycleServiceImpl lifecycleService = (LifecycleServiceImpl)this.client.getLifecycleService();
        lifecycleService.fireLifecycleEvent(state);
    }

    public void connectionAdded(Connection connection) {
    }

    public void connectionRemoved(Connection connection) {
        ClientExecutionServiceImpl executionService = (ClientExecutionServiceImpl)this.client.getClientExecutionService();
        if (connection.getEndPoint().equals((Object)this.ownerConnectionAddress) && this.client.getLifecycleService().isRunning()) {
            executionService.executeInternal(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClusterListenerSupport.this.fireConnectionEvent(LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED);
                        ClusterListenerSupport.this.connectToCluster();
                    }
                    catch (Exception e) {
                        LOGGER.warning("Could not re-connect to cluster shutting down the client", (Throwable)e);
                        ClusterListenerSupport.this.client.getLifecycleService().shutdown();
                    }
                }
            });
        }
    }

    @Override
    public void heartBeatStarted(Connection connection) {
    }

    @Override
    public void heartBeatStopped(Connection connection) {
        if (connection.getEndPoint().equals((Object)this.ownerConnectionAddress)) {
            this.connectionManager.destroyConnection(connection);
        }
    }

    private class ManagerAuthenticator
    implements Authenticator {
        private ManagerAuthenticator() {
        }

        @Override
        public void authenticate(ClientConnection connection) throws AuthenticationException, IOException {
            ClientMessage response;
            ClientMessage clientMessage;
            SerializationService ss = ClusterListenerSupport.this.client.getSerializationService();
            String uuid = "";
            String ownerUuid = "";
            if (ClusterListenerSupport.this.principal != null) {
                uuid = ClusterListenerSupport.this.principal.getUuid();
                ownerUuid = ClusterListenerSupport.this.principal.getOwnerUuid();
            }
            if (ClusterListenerSupport.this.credentials instanceof UsernamePasswordCredentials) {
                UsernamePasswordCredentials cr = (UsernamePasswordCredentials)ClusterListenerSupport.this.credentials;
                clientMessage = AuthenticationParameters.encode((String)cr.getUsername(), (String)cr.getPassword(), (String)uuid, (String)ownerUuid, (boolean)true);
            } else {
                Data data = ss.toData((Object)ClusterListenerSupport.this.credentials);
                clientMessage = AuthenticationCustomCredentialsParameters.encode((byte[])data.toByteArray(), (String)uuid, (String)ownerUuid, (boolean)true);
            }
            connection.init();
            ClientInvocation clientInvocation = new ClientInvocation(ClusterListenerSupport.this.client, clientMessage, connection);
            ClientInvocationFuture future = clientInvocation.invoke();
            try {
                response = (ClientMessage)future.get();
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e, IOException.class);
            }
            AuthenticationResultParameters resultParameters = AuthenticationResultParameters.decode((ClientMessage)response);
            connection.setRemoteEndpoint(resultParameters.address);
            ClusterListenerSupport.this.principal = new ClientPrincipal(resultParameters.uuid, resultParameters.ownerUuid);
        }
    }
}

