/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.ClusterAuthenticator;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationServiceSupport;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.security.Credentials;
import java.io.IOException;

public final class ClientSmartInvocationServiceImpl
extends ClientInvocationServiceSupport {
    private final LoadBalancer loadBalancer;
    private final Credentials credentials;
    private final ClusterAuthenticator authenticator;

    public ClientSmartInvocationServiceImpl(HazelcastClientInstanceImpl client, LoadBalancer loadBalancer) {
        super(client);
        this.loadBalancer = loadBalancer;
        this.credentials = client.getCredentials();
        this.authenticator = new ClusterAuthenticator(client, this.credentials);
    }

    @Override
    public void invokeOnPartitionOwner(ClientInvocation invocation, int partitionId) throws IOException {
        Address owner = this.partitionService.getPartitionOwner(partitionId);
        if (owner == null) {
            throw new IOException("Partition does not have owner. partitionId : " + partitionId);
        }
        ClientConnection connection = (ClientConnection)this.connectionManager.getOrConnect(owner, this.authenticator);
        invocation.getClientMessage().setPartitionId(partitionId);
        this.send(invocation, connection);
    }

    @Override
    public void invokeOnRandomTarget(ClientInvocation invocation) throws IOException {
        Address randomAddress = this.getRandomAddress();
        if (randomAddress == null) {
            throw new IOException("Not address found to invoke ");
        }
        Connection connection = this.connectionManager.getOrConnect(randomAddress, this.authenticator);
        this.send(invocation, (ClientConnection)connection);
    }

    @Override
    public void invokeOnTarget(ClientInvocation invocation, Address target) throws IOException {
        if (target == null) {
            throw new NullPointerException("Target can not be null");
        }
        if (!this.isMember(target)) {
            throw new IOException("Target :  " + target + " is not member. ");
        }
        Connection connection = this.connectionManager.getOrConnect(target, this.authenticator);
        this.invokeOnConnection(invocation, (ClientConnection)connection);
    }

    @Override
    public void invokeOnConnection(ClientInvocation invocation, ClientConnection connection) throws IOException {
        this.send(invocation, connection);
    }

    private Address getRandomAddress() {
        MemberImpl member = (MemberImpl)this.loadBalancer.next();
        if (member != null) {
            return member.getAddress();
        }
        return null;
    }

    private boolean isMember(Address target) {
        MemberImpl member = this.client.getClientClusterService().getMember(target);
        return member != null;
    }
}

