/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.AddListenerResultParameters;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.StripedExecutor;
import com.hazelcast.util.executor.StripedRunnable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;

public final class ClientListenerServiceImpl
implements ClientListenerService {
    private final ILogger logger = Logger.getLogger(ClientInvocationService.class);
    private final HazelcastClientInstanceImpl client;
    private final ClientInvocationService invocationService;
    private final ConcurrentMap<String, Integer> registrationMap = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<String, String> registrationAliasMap = new ConcurrentHashMap<String, String>();
    private final StripedExecutor eventExecutor;
    private final Set<ClientInvocation> failedListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public ClientListenerServiceImpl(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        this.client = client;
        this.invocationService = client.getInvocationService();
        this.eventExecutor = new StripedExecutor(this.logger, client.getName() + ".event", client.getThreadGroup(), eventThreadCount, eventQueueCapacity);
    }

    @Override
    public String startListening(ClientMessage clientMessage, Object key, EventHandler handler) {
        try {
            ClientInvocationFuture future;
            handler.beforeListenerRegister();
            if (key == null) {
                future = new ClientInvocation(this.client, handler, clientMessage).invoke();
            } else {
                int partitionId = this.client.getClientPartitionService().getPartitionId(key);
                future = new ClientInvocation(this.client, handler, clientMessage, partitionId).invoke();
            }
            ClientMessage responseMessage = (ClientMessage)future.get();
            AddListenerResultParameters eventResultParameters = AddListenerResultParameters.decode((ClientMessage)responseMessage);
            String registrationId = eventResultParameters.registrationId;
            this.registerListener(registrationId, clientMessage.getCorrelationId());
            return registrationId;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    @Override
    public boolean stopListening(ClientMessage clientMessage, String registrationId) {
        try {
            String realRegistrationId = this.deRegisterListener(registrationId);
            if (realRegistrationId == null) {
                return false;
            }
            ClientInvocationFuture future = new ClientInvocation(this.client, clientMessage).invoke();
            BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)future.get()));
            return resultParameters.result;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public void registerFailedListener(ClientInvocation future) {
        this.failedListeners.add(future);
    }

    public void triggerFailedListeners() {
        Iterator<ClientInvocation> iterator = this.failedListeners.iterator();
        while (iterator.hasNext()) {
            ClientInvocation failedListener = iterator.next();
            iterator.remove();
            failedListener.notifyException((Throwable)new TargetDisconnectedException());
        }
    }

    @Override
    public void registerListener(String uuid, Integer callId) {
        this.registrationAliasMap.put(uuid, uuid);
        this.registrationMap.put(uuid, callId);
    }

    public void reRegisterListener(String uuid, String alias, Integer callId) {
        String oldAlias = this.registrationAliasMap.put(uuid, alias);
        if (oldAlias != null) {
            this.registrationMap.remove(oldAlias);
            this.registrationMap.put(alias, callId);
        }
    }

    @Override
    public String deRegisterListener(String alias) {
        String uuid = (String)this.registrationAliasMap.remove(alias);
        if (uuid != null) {
            Integer callId = (Integer)this.registrationMap.remove(alias);
            this.invocationService.removeEventHandler(callId);
        }
        return uuid;
    }

    public void handleClientMessage(ClientMessage clientMessage) {
        try {
            this.eventExecutor.execute((Runnable)((Object)new ClientEventProcessor(clientMessage)));
        }
        catch (RejectedExecutionException e) {
            this.logger.log(Level.WARNING, " event clientMessage could not be handled ", (Throwable)e);
        }
    }

    public void shutdown() {
        this.eventExecutor.shutdown();
    }

    private final class ClientEventProcessor
    implements StripedRunnable {
        final ClientMessage clientMessage;

        private ClientEventProcessor(ClientMessage clientMessage) {
            this.clientMessage = clientMessage;
        }

        public void run() {
            int correlationId = this.clientMessage.getCorrelationId();
            EventHandler eventHandler = ClientListenerServiceImpl.this.invocationService.getEventHandler(correlationId);
            if (eventHandler == null) {
                ClientListenerServiceImpl.this.logger.warning("No eventHandler for callId: " + correlationId + ", event: " + this.clientMessage);
                return;
            }
            eventHandler.handle(this.clientMessage);
        }

        public int getKey() {
            return this.clientMessage.getPartitionId();
        }
    }
}

