/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.cache.impl.ClientCacheDistributedObject;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.AddDistributedObjectListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.CreateProxyParameters;
import com.hazelcast.client.impl.protocol.parameters.DistributedObjectEventParameters;
import com.hazelcast.client.impl.protocol.parameters.RemoveDistributedObjectListenerParameters;
import com.hazelcast.client.proxy.ClientAtomicLongProxy;
import com.hazelcast.client.proxy.ClientAtomicReferenceProxy;
import com.hazelcast.client.proxy.ClientCountDownLatchProxy;
import com.hazelcast.client.proxy.ClientExecutorServiceProxy;
import com.hazelcast.client.proxy.ClientIdGeneratorProxy;
import com.hazelcast.client.proxy.ClientListProxy;
import com.hazelcast.client.proxy.ClientLockProxy;
import com.hazelcast.client.proxy.ClientMapReduceProxy;
import com.hazelcast.client.proxy.ClientMultiMapProxy;
import com.hazelcast.client.proxy.ClientQueueProxy;
import com.hazelcast.client.proxy.ClientReplicatedMapProxy;
import com.hazelcast.client.proxy.ClientSemaphoreProxy;
import com.hazelcast.client.proxy.ClientSetProxy;
import com.hazelcast.client.proxy.ClientTopicProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ClientProxyFactory;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.txn.proxy.xa.XAResourceProxy;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.util.ExceptionUtil;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ProxyManager {
    private static final Class[] CONSTRUCTOR_ARGUMENT_TYPES = new Class[]{String.class, String.class};
    private final HazelcastClientInstanceImpl client;
    private final ConcurrentMap<String, ClientProxyFactory> proxyFactories = new ConcurrentHashMap<String, ClientProxyFactory>();
    private final ConcurrentMap<ObjectNamespace, ClientProxyFuture> proxies = new ConcurrentHashMap<ObjectNamespace, ClientProxyFuture>();

    public ProxyManager(HazelcastClientInstanceImpl client) {
        this.client = client;
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            for (ListenerConfig listenerConfig : listenerConfigs) {
                if (!(listenerConfig.getImplementation() instanceof DistributedObjectListener)) continue;
                this.addDistributedObjectListener((DistributedObjectListener)listenerConfig.getImplementation());
            }
        }
    }

    public void init(ClientConfig config) {
        this.register("hz:impl:mapService", this.getServiceProxy(MapService.class));
        this.register("hz:impl:cacheService", ClientCacheDistributedObject.class);
        this.register("hz:impl:queueService", ClientQueueProxy.class);
        this.register("hz:impl:multiMapService", ClientMultiMapProxy.class);
        this.register("hz:impl:listService", ClientListProxy.class);
        this.register("hz:impl:setService", ClientSetProxy.class);
        this.register("hz:impl:semaphoreService", ClientSemaphoreProxy.class);
        this.register("hz:impl:topicService", ClientTopicProxy.class);
        this.register("hz:impl:atomicLongService", ClientAtomicLongProxy.class);
        this.register("hz:impl:atomicReferenceService", ClientAtomicReferenceProxy.class);
        this.register("hz:impl:executorService", ClientExecutorServiceProxy.class);
        this.register("hz:impl:lockService", ClientLockProxy.class);
        this.register("hz:impl:countDownLatchService", ClientCountDownLatchProxy.class);
        this.register("hz:impl:mapReduceService", ClientMapReduceProxy.class);
        this.register("hz:impl:replicatedMapService", ClientReplicatedMapProxy.class);
        this.register("hz:impl:xaService", XAResourceProxy.class);
        this.register("hz:impl:idGeneratorService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                IAtomicLong atomicLong = ProxyManager.this.client.getAtomicLong("hz:atomic:idGenerator:" + id);
                return new ClientIdGeneratorProxy("hz:impl:idGeneratorService", id, atomicLong);
            }
        });
        for (ProxyFactoryConfig proxyFactoryConfig : config.getProxyFactoryConfigs()) {
            try {
                ClassLoader classLoader = config.getClassLoader();
                ClientProxyFactory clientProxyFactory = proxyFactoryConfig.getFactoryImpl();
                if (clientProxyFactory == null) {
                    String className = proxyFactoryConfig.getClassName();
                    clientProxyFactory = (ClientProxyFactory)ClassLoaderUtil.newInstance((ClassLoader)classLoader, (String)className);
                }
                this.register(proxyFactoryConfig.getService(), clientProxyFactory);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    private <T> Class<? extends ClientProxy> getServiceProxy(Class<T> service) {
        ClientExtension clientExtension = this.client.getClientExtension();
        return clientExtension.getServiceProxy(service);
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.client;
    }

    public void register(String serviceName, ClientProxyFactory factory) {
        if (this.proxyFactories.putIfAbsent(serviceName, factory) != null) {
            throw new IllegalArgumentException("Factory for service: " + serviceName + " is already registered!");
        }
    }

    public void register(final String serviceName, final Class<? extends ClientProxy> proxyType) {
        try {
            this.register(serviceName, new ClientProxyFactory(){

                @Override
                public ClientProxy create(String id) {
                    return (ClientProxy)ProxyManager.this.instantiateClientProxy(proxyType, serviceName, id);
                }
            });
        }
        catch (Exception e) {
            throw new HazelcastException("Could not initialize Proxy", (Throwable)e);
        }
    }

    public ClientProxy getOrCreateProxy(String service, String id) {
        DefaultObjectNamespace ns = new DefaultObjectNamespace(service, id);
        ClientProxyFuture proxyFuture = (ClientProxyFuture)this.proxies.get(ns);
        if (proxyFuture != null) {
            return proxyFuture.get();
        }
        ClientProxyFactory factory = (ClientProxyFactory)this.proxyFactories.get(service);
        if (factory == null) {
            throw new IllegalArgumentException("No factory registered for service: " + service);
        }
        ClientProxy clientProxy = factory.create(id);
        proxyFuture = new ClientProxyFuture();
        ClientProxyFuture current = this.proxies.putIfAbsent((ObjectNamespace)ns, proxyFuture);
        if (current != null) {
            return current.get();
        }
        try {
            this.initialize(clientProxy);
        }
        catch (Exception e) {
            this.proxies.remove(ns);
            proxyFuture.set(e);
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        proxyFuture.set(clientProxy);
        return clientProxy;
    }

    public void removeProxy(String service, String id) {
        DefaultObjectNamespace ns = new DefaultObjectNamespace(service, id);
        this.proxies.remove(ns);
    }

    private void initialize(ClientProxy clientProxy) throws Exception {
        ClientMessage clientMessage = CreateProxyParameters.encode((String)clientProxy.getName(), (String)clientProxy.getServiceName());
        ClientContext context = new ClientContext(this.client, this);
        new ClientInvocation(this.client, clientMessage).invoke().get();
        clientProxy.setContext(context);
        clientProxy.onInitialize();
    }

    public Collection<? extends DistributedObject> getDistributedObjects() {
        LinkedList<ClientProxy> objects = new LinkedList<ClientProxy>();
        for (ClientProxyFuture future : this.proxies.values()) {
            objects.add(future.get());
        }
        return objects;
    }

    public void destroy() {
        for (ClientProxyFuture future : this.proxies.values()) {
            future.get().onShutdown();
        }
        this.proxies.clear();
    }

    public String addDistributedObjectListener(final DistributedObjectListener listener) {
        ClientMessage request = AddDistributedObjectListenerParameters.encode();
        EventHandler<ClientMessage> eventHandler = new EventHandler<ClientMessage>(){

            @Override
            public void handle(ClientMessage clientMessage) {
                ClientProxy proxy;
                DistributedObjectEventParameters e = DistributedObjectEventParameters.decode((ClientMessage)clientMessage);
                DefaultObjectNamespace ns = new DefaultObjectNamespace(e.serviceName, e.name);
                ClientProxyFuture future = (ClientProxyFuture)ProxyManager.this.proxies.get(ns);
                ClientProxy clientProxy = proxy = future == null ? null : future.get();
                if (proxy == null) {
                    proxy = ProxyManager.this.getOrCreateProxy(e.serviceName, e.name);
                }
                DistributedObjectEvent event = new DistributedObjectEvent(e.eventType, e.serviceName, (DistributedObject)proxy);
                if (DistributedObjectEvent.EventType.CREATED.equals((Object)e.eventType)) {
                    listener.distributedObjectCreated(event);
                } else if (DistributedObjectEvent.EventType.DESTROYED.equals((Object)e.eventType)) {
                    listener.distributedObjectDestroyed(event);
                }
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
        return this.client.getListenerService().startListening(request, null, eventHandler);
    }

    public boolean removeDistributedObjectListener(String id) {
        ClientMessage request = RemoveDistributedObjectListenerParameters.encode((String)id);
        return this.client.getListenerService().stopListening(request, id);
    }

    private <T> T instantiateClientProxy(Class<T> proxyType, String serviceName, String id) {
        try {
            Constructor<T> constructor = proxyType.getConstructor(CONSTRUCTOR_ARGUMENT_TYPES);
            return constructor.newInstance(serviceName, id);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private static class ClientProxyFuture {
        volatile Object proxy;

        private ClientProxyFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClientProxy get() {
            if (this.proxy == null) {
                boolean interrupted = false;
                ClientProxyFuture clientProxyFuture = this;
                synchronized (clientProxyFuture) {
                    while (this.proxy == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.proxy instanceof Throwable) {
                throw ExceptionUtil.rethrow((Throwable)((Throwable)this.proxy));
            }
            return (ClientProxy)this.proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(Object o) {
            if (o == null) {
                throw new IllegalArgumentException();
            }
            ClientProxyFuture clientProxyFuture = this;
            synchronized (clientProxyFuture) {
                this.proxy = o;
                this.notifyAll();
            }
        }
    }
}

