/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.AddPartitionLostListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.PartitionLostEventParameters;
import com.hazelcast.client.impl.protocol.parameters.RemovePartitionLostListenerParameters;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.Member;
import com.hazelcast.core.MigrationListener;
import com.hazelcast.core.Partition;
import com.hazelcast.core.PartitionService;
import com.hazelcast.partition.PartitionLostEvent;
import com.hazelcast.partition.PartitionLostListener;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class PartitionServiceProxy
implements PartitionService {
    private final ClientPartitionService partitionService;
    private final ClientListenerService listenerService;
    private final Random random = new Random();

    public PartitionServiceProxy(ClientPartitionService partitionService, ClientListenerService listenerService) {
        this.partitionService = partitionService;
        this.listenerService = listenerService;
    }

    public String randomPartitionKey() {
        return Integer.toString(this.random.nextInt(this.partitionService.getPartitionCount()));
    }

    public Set<Partition> getPartitions() {
        int partitionCount = this.partitionService.getPartitionCount();
        LinkedHashSet<Partition> partitions = new LinkedHashSet<Partition>(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            Partition partition = this.partitionService.getPartition(i);
            partitions.add(partition);
        }
        return partitions;
    }

    public Partition getPartition(Object key) {
        int partitionId = this.partitionService.getPartitionId(key);
        return this.partitionService.getPartition(partitionId);
    }

    public String addMigrationListener(MigrationListener migrationListener) {
        throw new UnsupportedOperationException();
    }

    public boolean removeMigrationListener(String registrationId) {
        throw new UnsupportedOperationException();
    }

    public String addPartitionLostListener(PartitionLostListener partitionLostListener) {
        ClientMessage request = AddPartitionLostListenerParameters.encode();
        ClientPartitionLostEventHandler handler = new ClientPartitionLostEventHandler(partitionLostListener);
        return this.listenerService.startListening(request, null, handler);
    }

    public boolean removePartitionLostListener(String registrationId) {
        ClientMessage request = RemovePartitionLostListenerParameters.encode((String)registrationId);
        return this.listenerService.stopListening(request, registrationId);
    }

    public boolean isClusterSafe() {
        throw new UnsupportedOperationException();
    }

    public boolean isMemberSafe(Member member) {
        throw new UnsupportedOperationException();
    }

    public boolean isLocalMemberSafe() {
        throw new UnsupportedOperationException();
    }

    public boolean forceLocalMemberToBeSafe(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    private static class ClientPartitionLostEventHandler
    implements EventHandler<ClientMessage> {
        private PartitionLostListener listener;

        public ClientPartitionLostEventHandler(PartitionLostListener listener) {
            this.listener = listener;
        }

        @Override
        public void handle(ClientMessage clientMessage) {
            PartitionLostEventParameters event = PartitionLostEventParameters.decode((ClientMessage)clientMessage);
            this.listener.partitionLost(new PartitionLostEvent(event.partitionId, event.lostBackupCount, event.source));
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

