/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.TopicAddMessageListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.TopicEventParameters;
import com.hazelcast.client.impl.protocol.parameters.TopicPublishParameters;
import com.hazelcast.client.impl.protocol.parameters.TopicRemoveMessageListenerParameters;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;

public class ClientTopicProxy<E>
extends ClientProxy
implements ITopic<E> {
    private final String name;
    private volatile Data key;

    public ClientTopicProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    public void publish(E message) {
        SerializationService serializationService = this.getContext().getSerializationService();
        Data data = serializationService.toData(message);
        ClientMessage request = TopicPublishParameters.encode((String)this.name, (Data)data);
        this.invoke(request);
    }

    public String addMessageListener(final MessageListener<E> listener) {
        ClientMessage request = TopicAddMessageListenerParameters.encode((String)this.name);
        EventHandler<ClientMessage> handler = new EventHandler<ClientMessage>(){
            final SerializationService serializationService;
            final ClientClusterService clusterService;
            {
                this.serializationService = ClientTopicProxy.this.getContext().getSerializationService();
                this.clusterService = ClientTopicProxy.this.getContext().getClusterService();
            }

            @Override
            public void handle(ClientMessage msg) {
                TopicEventParameters event = TopicEventParameters.decode((ClientMessage)msg);
                Object messageObject = this.serializationService.toObject((Object)event.message);
                MemberImpl member = this.clusterService.getMember(event.uuid);
                Message message = new Message(ClientTopicProxy.this.name, messageObject, event.publishTime, (Member)member);
                listener.onMessage(message);
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
        return this.listen(request, this.getKey(), handler);
    }

    public boolean removeMessageListener(String registrationId) {
        ClientMessage request = TopicRemoveMessageListenerParameters.encode((String)this.name, (String)registrationId);
        return this.stopListening(request, registrationId);
    }

    public LocalTopicStats getLocalTopicStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.getContext().getSerializationService().toData((Object)this.name);
        }
        return this.key;
    }

    @Override
    protected <T> T invoke(ClientMessage clientMessage) {
        return super.invoke(clientMessage, this.getKey());
    }

    public String toString() {
        return "ITopic{name='" + this.getName() + '\'' + '}';
    }
}

