/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.DataCollectionResultParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.ItemEventParameters;
import com.hazelcast.client.impl.protocol.parameters.SetAddAllParameters;
import com.hazelcast.client.impl.protocol.parameters.SetAddListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.SetAddParameters;
import com.hazelcast.client.impl.protocol.parameters.SetClearParameters;
import com.hazelcast.client.impl.protocol.parameters.SetCompareAndRemoveAllParameters;
import com.hazelcast.client.impl.protocol.parameters.SetCompareAndRetainAllParameters;
import com.hazelcast.client.impl.protocol.parameters.SetContainsAllParameters;
import com.hazelcast.client.impl.protocol.parameters.SetContainsParameters;
import com.hazelcast.client.impl.protocol.parameters.SetGetAllParameters;
import com.hazelcast.client.impl.protocol.parameters.SetIsEmptyParameters;
import com.hazelcast.client.impl.protocol.parameters.SetRemoveListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.SetRemoveParameters;
import com.hazelcast.client.impl.protocol.parameters.SetSizeParameters;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class ClientSetProxy<E>
extends ClientProxy
implements ISet<E> {
    private final String name;

    public ClientSetProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    public int size() {
        ClientMessage request = SetSizeParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean isEmpty() {
        ClientMessage request = SetIsEmptyParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean contains(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = SetContainsParameters.encode((String)this.name, (Data)value);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.getAll()).iterator();
    }

    public Object[] toArray() {
        return this.getAll().toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.getAll().toArray(a);
    }

    public boolean add(E e) {
        this.throwExceptionIfNull(e);
        Data element = this.toData(e);
        ClientMessage request = SetAddParameters.encode((String)this.name, (Data)element);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean remove(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = SetRemoveParameters.encode((String)this.name, (Data)value);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean containsAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>(c.size());
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = SetContainsAllParameters.encode((String)this.name, valueSet);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean addAll(Collection<? extends E> c) {
        this.throwExceptionIfNull(c);
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        for (E e : c) {
            this.throwExceptionIfNull(e);
            valueList.add(this.toData(e));
        }
        ClientMessage request = SetAddAllParameters.encode((String)this.name, valueList);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean removeAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>();
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = SetCompareAndRemoveAllParameters.encode((String)this.name, valueSet);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean retainAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>();
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = SetCompareAndRetainAllParameters.encode((String)this.name, valueSet);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public void clear() {
        ClientMessage request = SetClearParameters.encode((String)this.name);
        this.invoke(request);
    }

    public String addItemListener(final ItemListener<E> listener, final boolean includeValue) {
        ClientMessage request = SetAddListenerParameters.encode((String)this.name, (boolean)includeValue);
        EventHandler<ClientMessage> eventHandler = new EventHandler<ClientMessage>(){
            final SerializationService serializationService;
            final ClientClusterService clusterService;
            {
                this.serializationService = ClientSetProxy.this.getContext().getSerializationService();
                this.clusterService = ClientSetProxy.this.getContext().getClusterService();
            }

            @Override
            public void handle(ClientMessage message) {
                ItemEventParameters event = ItemEventParameters.decode((ClientMessage)message);
                Object item = includeValue ? this.serializationService.toObject((Object)event.item) : null;
                MemberImpl member = this.clusterService.getMember(event.uuid);
                ItemEvent itemEvent = new ItemEvent(ClientSetProxy.this.name, event.eventType, item, (Member)member);
                if (event.eventType == ItemEventType.ADDED) {
                    listener.itemAdded(itemEvent);
                } else {
                    listener.itemRemoved(itemEvent);
                }
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
        return this.listen(request, this.getPartitionKey(), eventHandler);
    }

    public boolean removeItemListener(String registrationId) {
        ClientMessage request = SetRemoveListenerParameters.encode((String)this.name, (String)registrationId);
        return this.stopListening(request, registrationId);
    }

    private Collection<E> getAll() {
        ClientMessage request = SetGetAllParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection resultCollection = resultParameters.result;
        ArrayList list = new ArrayList(resultCollection.size());
        for (Data value : resultCollection) {
            list.add(this.toObject(value));
        }
        return list;
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getPartitionKey());
    }

    public String toString() {
        return "ISet{name='" + this.getName() + '\'' + '}';
    }
}

