/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.SemaphoreAcquireParameters;
import com.hazelcast.client.impl.protocol.parameters.SemaphoreAvailablePermitsParameters;
import com.hazelcast.client.impl.protocol.parameters.SemaphoreDrainPermitsParameters;
import com.hazelcast.client.impl.protocol.parameters.SemaphoreInitParameters;
import com.hazelcast.client.impl.protocol.parameters.SemaphoreReducePermitsParameters;
import com.hazelcast.client.impl.protocol.parameters.SemaphoreReleaseParameters;
import com.hazelcast.client.impl.protocol.parameters.SemaphoreTryAcquireParameters;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.nio.serialization.Data;
import java.util.concurrent.TimeUnit;

public class ClientSemaphoreProxy
extends ClientProxy
implements ISemaphore {
    private final String name;
    private volatile Data key;

    public ClientSemaphoreProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    public boolean init(int permits) {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreInitParameters.encode((String)this.name, (int)permits);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public void acquire() throws InterruptedException {
        ClientMessage request = SemaphoreAcquireParameters.encode((String)this.name, (int)1);
        this.invoke(request);
    }

    public void acquire(int permits) throws InterruptedException {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreAcquireParameters.encode((String)this.name, (int)1);
        this.invoke(request);
    }

    public int availablePermits() {
        ClientMessage request = SemaphoreAvailablePermitsParameters.encode((String)this.name);
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public int drainPermits() {
        ClientMessage request = SemaphoreDrainPermitsParameters.encode((String)this.name);
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public void reducePermits(int reduction) {
        this.checkNegative(reduction);
        ClientMessage request = SemaphoreReducePermitsParameters.encode((String)this.name, (int)reduction);
        this.invoke(request);
    }

    public void release() {
        ClientMessage request = SemaphoreReleaseParameters.encode((String)this.name, (int)1);
        this.invoke(request);
    }

    public void release(int permits) {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreReleaseParameters.encode((String)this.name, (int)permits);
        this.invoke(request);
    }

    public boolean tryAcquire() {
        ClientMessage request = SemaphoreTryAcquireParameters.encode((String)this.name, (int)1, (long)0L);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public boolean tryAcquire(int permits) {
        this.checkNegative(permits);
        try {
            return this.tryAcquire(permits, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout == 0L) {
            return this.tryAcquire();
        }
        ClientMessage request = SemaphoreTryAcquireParameters.encode((String)this.name, (int)1, (long)unit.toMillis(timeout));
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkNegative(permits);
        ClientMessage request = SemaphoreTryAcquireParameters.encode((String)this.name, (int)permits, (long)unit.toMillis(timeout));
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getKey());
    }

    public Data getKey() {
        if (this.key == null) {
            this.key = this.getContext().getSerializationService().toData((Object)this.name);
        }
        return this.key;
    }

    private void checkNegative(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits cannot be negative!");
        }
    }

    public String toString() {
        return "ISemaphore{name='" + this.getName() + '\'' + '}';
    }
}

