/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.DataCollectionResultParameters;
import com.hazelcast.client.impl.protocol.parameters.DataEntryListResultParameters;
import com.hazelcast.client.impl.protocol.parameters.EntryEventParameters;
import com.hazelcast.client.impl.protocol.parameters.GenericResultParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapAddEntryListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapAddEntryListenerToKeyParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapAddEntryListenerToKeyWithPredicateParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapAddEntryListenerWithPredicateParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapClearParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapContainsKeyParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapContainsValueParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapEntrySetParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapGetParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapIsEmptyParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapKeySetParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapPutAllParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapPutParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapRemoveEntryListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapRemoveParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapSizeParameters;
import com.hazelcast.client.impl.protocol.parameters.ReplicatedMapValuesParameters;
import com.hazelcast.client.nearcache.ClientHeapNearCache;
import com.hazelcast.client.nearcache.ClientNearCache;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientReplicatedMapProxy<K, V>
extends ClientProxy
implements ReplicatedMap<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private volatile ClientHeapNearCache<Object> nearCache;
    private final AtomicBoolean nearCacheInitialized = new AtomicBoolean();

    public ClientReplicatedMapProxy(String serviceName, String objectName) {
        super(serviceName, objectName);
    }

    @Override
    protected void onDestroy() {
        if (this.nearCache != null) {
            this.nearCache.destroy();
        }
    }

    public V put(K key, V value, long ttl, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapPutParameters.encode((String)this.getName(), (Data)keyData, (Data)valueData, (long)timeUnit.toMillis(ttl));
        ClientMessage response = (ClientMessage)this.invoke(request);
        return (V)this.toObject(response);
    }

    public int size() {
        ClientMessage request = ReplicatedMapSizeParameters.encode((String)this.getName());
        ClientMessage response = (ClientMessage)this.invoke(request);
        IntResultParameters result = IntResultParameters.decode((ClientMessage)response);
        return result.result;
    }

    public boolean isEmpty() {
        ClientMessage request = ReplicatedMapIsEmptyParameters.encode((String)this.getName());
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters result = BooleanResultParameters.decode((ClientMessage)response);
        return result.result;
    }

    public boolean containsKey(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapContainsKeyParameters.encode((String)this.getName(), (Data)keyData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters result = BooleanResultParameters.decode((ClientMessage)response);
        return result.result;
    }

    public boolean containsValue(Object value) {
        Preconditions.checkNotNull((Object)value, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        ClientMessage request = ReplicatedMapContainsValueParameters.encode((String)this.getName(), (Data)valueData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters result = BooleanResultParameters.decode((ClientMessage)response);
        return result.result;
    }

    public V get(Object key) {
        Object cached;
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        this.initNearCache();
        if (this.nearCache != null && (cached = this.nearCache.get(key)) != null) {
            if (cached.equals(ClientNearCache.NULL_OBJECT)) {
                return null;
            }
            return (V)cached;
        }
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapGetParameters.encode((String)this.getName(), (Data)keyData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        GenericResultParameters result = GenericResultParameters.decode((ClientMessage)response);
        Object value = this.toObject(result.result);
        if (this.nearCache != null) {
            this.nearCache.put(key, value);
        }
        return (V)value;
    }

    public V put(K key, V value) {
        return this.put(key, value, 0L, TimeUnit.MILLISECONDS);
    }

    public V remove(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapRemoveParameters.encode((String)this.getName(), (Data)keyData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        GenericResultParameters result = GenericResultParameters.decode((ClientMessage)response);
        return (V)this.toObject(result.result);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        ArrayList<Data> keyList = new ArrayList<Data>(m.size());
        ArrayList<Data> valueList = new ArrayList<Data>(m.size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            keyList.add(this.toData(entry.getKey()));
            valueList.add(this.toData(entry.getValue()));
        }
        ClientMessage request = ReplicatedMapPutAllParameters.encode((String)this.getName(), keyList, valueList);
        this.invoke(request);
    }

    public void clear() {
        ClientMessage request = ReplicatedMapClearParameters.encode((String)this.getName());
        ClientMessage response = (ClientMessage)this.invoke(request);
        this.invoke(response);
    }

    public boolean removeEntryListener(String id) {
        ClientMessage request = ReplicatedMapRemoveEntryListenerParameters.encode((String)this.getName(), (String)id);
        return this.stopListening(request, id);
    }

    public String addEntryListener(EntryListener<K, V> listener) {
        ClientMessage request = ReplicatedMapAddEntryListenerParameters.encode((String)this.getName());
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.listen(request, null, handler);
    }

    public String addEntryListener(EntryListener<K, V> listener, K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapAddEntryListenerToKeyParameters.encode((String)this.getName(), (Data)keyData);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.listen(request, keyData, handler);
    }

    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate) {
        Data predicateData = this.toData(predicate);
        ClientMessage request = ReplicatedMapAddEntryListenerWithPredicateParameters.encode((String)this.getName(), (Data)predicateData);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.listen(request, null, handler);
    }

    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data predicateData = this.toData(predicate);
        ClientMessage request = ReplicatedMapAddEntryListenerToKeyWithPredicateParameters.encode((String)this.getName(), (Data)keyData, (Data)predicateData);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.listen(request, keyData, handler);
    }

    public Set<K> keySet() {
        ClientMessage request = ReplicatedMapKeySetParameters.encode((String)this.getName());
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters result = DataCollectionResultParameters.decode((ClientMessage)response);
        HashSet resultSet = new HashSet(result.result.size());
        for (Data data : result.result) {
            resultSet.add(this.toObject(data));
        }
        return resultSet;
    }

    public Collection<V> values() {
        ClientMessage request = ReplicatedMapValuesParameters.encode((String)this.getName());
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters result = DataCollectionResultParameters.decode((ClientMessage)response);
        ArrayList resultCollection = new ArrayList(result.result.size());
        for (Data data : result.result) {
            resultCollection.add(this.toObject(data));
        }
        return resultCollection;
    }

    public Collection<V> values(Comparator<V> comparator) {
        List values = (List)this.values();
        Collections.sort(values, comparator);
        return values;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = ReplicatedMapEntrySetParameters.encode((String)this.getName());
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataEntryListResultParameters result = DataEntryListResultParameters.decode((ClientMessage)response);
        int size = result.keys.size();
        HashSet<Map.Entry<K, V>> resultCollection = new HashSet<Map.Entry<K, V>>(size);
        for (int i = 0; i < size; ++i) {
            Object key = this.toObject(result.keys.get(i));
            Object value = this.toObject(result.values.get(i));
            resultCollection.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        return resultCollection;
    }

    private EventHandler<ClientMessage> createHandler(EntryListener<K, V> listener) {
        return new ReplicatedMapEventHandler(listener);
    }

    private void initNearCache() {
        if (this.nearCacheInitialized.compareAndSet(false, true)) {
            NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.getName());
            if (nearCacheConfig == null) {
                return;
            }
            ClientHeapNearCache nearCache = new ClientHeapNearCache(this.getName(), this.getContext(), nearCacheConfig);
            this.nearCache = nearCache;
        }
    }

    public String toString() {
        return "ReplicatedMap{name='" + this.getName() + '\'' + '}';
    }

    private class ReplicatedMapEventHandler
    implements EventHandler<ClientMessage> {
        private final EntryListener<K, V> listener;

        public ReplicatedMapEventHandler(EntryListener<K, V> listener) {
            this.listener = listener;
        }

        @Override
        public void handle(ClientMessage clientMessage) {
            EntryEventParameters event = EntryEventParameters.decode((ClientMessage)clientMessage);
            Object value = ClientReplicatedMapProxy.this.toObject(event.value);
            Object oldValue = ClientReplicatedMapProxy.this.toObject(event.oldValue);
            Object key = ClientReplicatedMapProxy.this.toObject(event.key);
            MemberImpl member = ClientReplicatedMapProxy.this.getContext().getClusterService().getMember(event.uuid);
            EntryEvent entryEvent = new EntryEvent((Object)ClientReplicatedMapProxy.this.getName(), (Member)member, event.eventType, key, oldValue, value);
            EntryEventType eventType = EntryEventType.getByType((int)event.eventType);
            switch (eventType) {
                case ADDED: {
                    this.listener.entryAdded(entryEvent);
                    break;
                }
                case REMOVED: {
                    this.listener.entryRemoved(entryEvent);
                    break;
                }
                case UPDATED: {
                    this.listener.entryUpdated(entryEvent);
                    break;
                }
                case EVICTED: {
                    this.listener.entryEvicted(entryEvent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + eventType);
                }
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

