/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.DataCollectionResultParameters;
import com.hazelcast.client.impl.protocol.parameters.GenericResultParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.ItemEventParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueAddAllParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueAddListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueClearParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueCompareAndRemoveAllParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueCompareAndRetainAllParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueContainsAllParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueContainsParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueDrainToMaxSizeParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueIsEmptyParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueIteratorParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueOfferParameters;
import com.hazelcast.client.impl.protocol.parameters.QueuePeekParameters;
import com.hazelcast.client.impl.protocol.parameters.QueuePollParameters;
import com.hazelcast.client.impl.protocol.parameters.QueuePutParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueRemainingCapacityParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueRemoveListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueRemoveParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueSizeParameters;
import com.hazelcast.client.impl.protocol.parameters.QueueTakeParameters;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.collection.impl.queue.QueueIterator;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public final class ClientQueueProxy<E>
extends ClientProxy
implements IQueue<E> {
    private final String name;

    public ClientQueueProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    public String addItemListener(final ItemListener<E> listener, final boolean includeValue) {
        ClientMessage request = QueueAddListenerParameters.encode((String)this.name, (boolean)includeValue);
        EventHandler<ClientMessage> eventHandler = new EventHandler<ClientMessage>(){
            final SerializationService serializationService;
            final ClientClusterService clusterService;
            {
                this.serializationService = ClientQueueProxy.this.getContext().getSerializationService();
                this.clusterService = ClientQueueProxy.this.getContext().getClusterService();
            }

            @Override
            public void handle(ClientMessage message) {
                ItemEventParameters event = ItemEventParameters.decode((ClientMessage)message);
                Object item = includeValue ? this.serializationService.toObject((Object)event.item) : null;
                MemberImpl member = this.clusterService.getMember(event.uuid);
                ItemEvent itemEvent = new ItemEvent(ClientQueueProxy.this.name, event.eventType, item, (Member)member);
                if (event.eventType == ItemEventType.ADDED) {
                    listener.itemAdded(itemEvent);
                } else {
                    listener.itemRemoved(itemEvent);
                }
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
        return this.listen(request, this.getPartitionKey(), eventHandler);
    }

    public boolean removeItemListener(String registrationId) {
        ClientMessage request = QueueRemoveListenerParameters.encode((String)this.name, (String)registrationId);
        return this.stopListening(request, registrationId);
    }

    public LocalQueueStats getLocalQueueStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue is full!");
    }

    public boolean offer(E e) {
        try {
            return this.offer(e, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public void put(E e) throws InterruptedException {
        Data data = this.toData(e);
        ClientMessage request = QueuePutParameters.encode((String)this.name, (Data)data);
        this.invokeInterruptibly(request);
    }

    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Data data = this.toData(e);
        ClientMessage request = QueueOfferParameters.encode((String)this.name, (Data)data, (long)unit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invokeInterruptibly(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public E take() throws InterruptedException {
        ClientMessage request = QueueTakeParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invokeInterruptibly(request);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)response);
        return (E)this.toObject(resultParameters.result);
    }

    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        ClientMessage request = QueuePollParameters.encode((String)this.name, (long)unit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invokeInterruptibly(request);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)response);
        return (E)this.toObject(resultParameters.result);
    }

    public int remainingCapacity() {
        ClientMessage request = QueueRemainingCapacityParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean remove(Object o) {
        Data data = this.toData(o);
        ClientMessage request = QueueRemoveParameters.encode((String)this.name, (Data)data);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean contains(Object o) {
        Data data = this.toData(o);
        ClientMessage request = QueueContainsParameters.encode((String)this.name, (Data)data);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public int drainTo(Collection<? super E> objects) {
        return this.drainTo(objects, -1);
    }

    public int drainTo(Collection<? super E> c, int maxElements) {
        ClientMessage request = QueueDrainToMaxSizeParameters.encode((String)this.name, (int)maxElements);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection resultCollection = resultParameters.result;
        for (Data data : resultCollection) {
            Object e = this.toObject(data);
            c.add(e);
        }
        return resultCollection.size();
    }

    public E remove() {
        E res = this.poll();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    public E poll() {
        try {
            return this.poll(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public E element() {
        E res = this.peek();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    public E peek() {
        ClientMessage request = QueuePeekParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)response);
        return (E)this.toObject(resultParameters.result);
    }

    public int size() {
        ClientMessage request = QueueSizeParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean isEmpty() {
        ClientMessage request = QueueIsEmptyParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public Iterator<E> iterator() {
        ClientMessage request = QueueIteratorParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection resultCollection = resultParameters.result;
        return new QueueIterator(resultCollection.iterator(), this.getContext().getSerializationService(), false);
    }

    public Object[] toArray() {
        ClientMessage request = QueueIteratorParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection resultCollection = resultParameters.result;
        int i = 0;
        Object[] array = new Object[resultCollection.size()];
        for (Data data : resultCollection) {
            array[i++] = this.toObject(data);
        }
        return array;
    }

    public <T> T[] toArray(T[] ts) {
        ClientMessage request = QueueIteratorParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection resultCollection = resultParameters.result;
        int size = resultCollection.size();
        if (ts.length < size) {
            ts = (Object[])Array.newInstance(ts.getClass().getComponentType(), size);
        }
        int i = 0;
        for (Data data : resultCollection) {
            ts[i++] = this.toObject(data);
        }
        return ts;
    }

    public boolean containsAll(Collection<?> c) {
        ClientMessage request = QueueContainsAllParameters.encode((String)this.name, this.getDataList(c));
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean addAll(Collection<? extends E> c) {
        ClientMessage request = QueueAddAllParameters.encode((String)this.name, this.getDataList(c));
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean removeAll(Collection<?> c) {
        ClientMessage request = QueueCompareAndRemoveAllParameters.encode((String)this.name, this.getDataList(c));
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean retainAll(Collection<?> c) {
        ClientMessage request = QueueCompareAndRetainAllParameters.encode((String)this.name, this.getDataList(c));
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public void clear() {
        ClientMessage request = QueueClearParameters.encode((String)this.name);
        this.invoke(request);
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getPartitionKey());
    }

    protected <T> T invokeInterruptibly(ClientMessage req) throws InterruptedException {
        return super.invokeInterruptibly(req, this.getPartitionKey());
    }

    private List<Data> getDataList(Collection<?> objects) {
        ArrayList<Data> dataList = new ArrayList<Data>(objects.size());
        for (Object o : objects) {
            dataList.add(this.toData(o));
        }
        return dataList;
    }

    public String toString() {
        return "IQueue{name='" + this.getName() + '\'' + '}';
    }
}

