/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.DataCollectionResultParameters;
import com.hazelcast.client.impl.protocol.parameters.DataEntryListResultParameters;
import com.hazelcast.client.impl.protocol.parameters.EntryEventParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapAddEntryListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapAddEntryListenerToKeyParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapClearParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapContainsEntryParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapContainsKeyParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapContainsValueParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapEntrySetParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapForceUnlockParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapGetParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapIsLockedParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapKeySetParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapLockParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapPutParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapRemoveEntryListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapRemoveEntryParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapRemoveParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapSizeParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapTryLockParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapUnlockParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapValueCountParameters;
import com.hazelcast.client.impl.protocol.parameters.MultiMapValuesParameters;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapters;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMultiMapStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientMultiMapProxy<K, V>
extends ClientProxy
implements MultiMap<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private final String name;

    public ClientMultiMapProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    public boolean put(K key, V value) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MultiMapPutParameters.encode((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public Collection<V> get(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapGetParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection result = resultParameters.result;
        ArrayList resultCollection = new ArrayList(result.size());
        for (Data data : result) {
            Object value = this.toObject(data);
            resultCollection.add(value);
        }
        return resultCollection;
    }

    public boolean remove(Object key, Object value) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MultiMapRemoveEntryParameters.encode((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public Collection<V> remove(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapRemoveParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection result = resultParameters.result;
        ArrayList resultCollection = new ArrayList(result.size());
        for (Data data : result) {
            Object value = this.toObject(data);
            resultCollection.add(value);
        }
        return resultCollection;
    }

    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    public Set<K> keySet() {
        ClientMessage request = MultiMapKeySetParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection result = resultParameters.result;
        HashSet keySet = new HashSet(result.size());
        for (Data data : result) {
            Object key = this.toObject(data);
            keySet.add(key);
        }
        return keySet;
    }

    public Collection<V> values() {
        ClientMessage request = MultiMapValuesParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection result = resultParameters.result;
        ArrayList resultCollection = new ArrayList(result.size());
        for (Data data : result) {
            Object value = this.toObject(data);
            resultCollection.add(value);
        }
        return resultCollection;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = MultiMapEntrySetParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataEntryListResultParameters resultParameters = DataEntryListResultParameters.decode((ClientMessage)response);
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        int size = resultParameters.keys.size();
        for (int i = 0; i < size; ++i) {
            Data keyData = (Data)resultParameters.keys.get(i);
            Data valueData = (Data)resultParameters.values.get(i);
            Object key = this.toObject(keyData);
            Object value = this.toObject(valueData);
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        return entrySet;
    }

    public boolean containsKey(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapContainsKeyParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean containsValue(Object value) {
        Preconditions.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyValue = this.toData(value);
        ClientMessage request = MultiMapContainsValueParameters.encode((String)this.name, (Data)keyValue);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean containsEntry(K key, V value) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MultiMapContainsEntryParameters.encode((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public int size() {
        ClientMessage request = MultiMapSizeParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public void clear() {
        ClientMessage request = MultiMapClearParameters.encode((String)this.name);
        this.invoke(request);
    }

    public int valueCount(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapValueCountParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public String addLocalEntryListener(EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        Preconditions.isNotNull(listener, (String)"listener");
        ClientMessage request = MultiMapAddEntryListenerParameters.encode((String)this.name, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        return this.listen(request, handler);
    }

    public boolean removeEntryListener(String registrationId) {
        ClientMessage request = MultiMapRemoveEntryListenerParameters.encode((String)this.name, (String)registrationId);
        return this.stopListening(request, registrationId);
    }

    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapAddEntryListenerToKeyParameters.encode((String)this.name, (Data)keyData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        return this.listen(request, keyData, handler);
    }

    public void lock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapLockParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(-1L, TimeUnit.MILLISECONDS));
        this.invoke(request, keyData);
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkPositive((long)leaseTime, (String)"leaseTime should be positive");
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapLockParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(leaseTime, timeUnit));
        this.invoke(request, keyData);
    }

    public boolean isLocked(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapIsLockedParameters.encode((String)this.name, (Data)keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean tryLock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        try {
            return this.tryLock(key, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapTryLockParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)timeunit.toMillis(time));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public void unlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapUnlockParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        this.invoke(request, keyData);
    }

    public void forceUnlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapForceUnlockParameters.encode((String)this.name, (Data)keyData);
        this.invoke(request, keyData);
    }

    public LocalMultiMapStats getLocalMultiMapStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getContext().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-multimap-" + this.getName());
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            Preconditions.isNotNull((Object)jobTracker, (String)"jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMultiMap((MultiMap)this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory != null ? mappingJob.combiner(combinerFactory).reducer(reducerFactory) : mappingJob.reducer(reducerFactory);
            JobCompletableFuture future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException((Throwable)e);
        }
    }

    @Override
    protected void onDestroy() {
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<ClientMessage> createHandler(Object listener, boolean includeValue) {
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        return new ClientMultiMapEventHandler(listenerAdaptor, includeValue);
    }

    public String toString() {
        return "MultiMap{name='" + this.getName() + '\'' + '}';
    }

    private class ClientMultiMapEventHandler
    implements EventHandler<ClientMessage> {
        private final ListenerAdapter listenerAdapter;
        private final boolean includeValue;

        public ClientMultiMapEventHandler(ListenerAdapter listenerAdapter, boolean includeValue) {
            this.listenerAdapter = listenerAdapter;
            this.includeValue = includeValue;
        }

        @Override
        public void handle(ClientMessage clientMessage) {
            EntryEventParameters event = EntryEventParameters.decode((ClientMessage)clientMessage);
            MemberImpl member = ClientMultiMapProxy.this.getContext().getClusterService().getMember(event.uuid);
            IMapEvent iMapEvent = this.createIMapEvent(event, (Member)member);
            this.listenerAdapter.onEvent(iMapEvent);
        }

        private IMapEvent createIMapEvent(EntryEventParameters event, Member member) {
            MapEvent iMapEvent;
            EntryEventType entryEventType = EntryEventType.getByType((int)event.eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: {
                    iMapEvent = this.createEntryEvent(event, member);
                    break;
                }
                case CLEAR_ALL: {
                    iMapEvent = this.createMapEvent(event, member);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + entryEventType);
                }
            }
            return iMapEvent;
        }

        private MapEvent createMapEvent(EntryEventParameters event, Member member) {
            return new MapEvent((Object)ClientMultiMapProxy.this.name, member, event.eventType, event.numberOfAffectedEntries);
        }

        private EntryEvent<K, V> createEntryEvent(EntryEventParameters event, Member member) {
            Object value = null;
            Object oldValue = null;
            if (this.includeValue) {
                value = ClientMultiMapProxy.this.toObject(event.value);
                oldValue = ClientMultiMapProxy.this.toObject(event.oldValue);
            }
            Object key = ClientMultiMapProxy.this.toObject(event.key);
            return new EntryEvent((Object)ClientMultiMapProxy.this.name, member, event.eventType, key, oldValue, value);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

