/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.AddListenerResultParameters;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.DataCollectionResultParameters;
import com.hazelcast.client.impl.protocol.parameters.DataEntryListResultParameters;
import com.hazelcast.client.impl.protocol.parameters.EntryEventParameters;
import com.hazelcast.client.impl.protocol.parameters.EntryViewParameters;
import com.hazelcast.client.impl.protocol.parameters.GenericResultParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.MapAddEntryListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.MapAddEntryListenerToKeyParameters;
import com.hazelcast.client.impl.protocol.parameters.MapAddEntryListenerToKeyWithPredicateParameters;
import com.hazelcast.client.impl.protocol.parameters.MapAddEntryListenerWithPredicateParameters;
import com.hazelcast.client.impl.protocol.parameters.MapAddIndexParameters;
import com.hazelcast.client.impl.protocol.parameters.MapAddInterceptorParameters;
import com.hazelcast.client.impl.protocol.parameters.MapAddNearCacheEntryListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.MapAddPartitionLostListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.MapClearParameters;
import com.hazelcast.client.impl.protocol.parameters.MapContainsKeyParameters;
import com.hazelcast.client.impl.protocol.parameters.MapContainsValueParameters;
import com.hazelcast.client.impl.protocol.parameters.MapDeleteParameters;
import com.hazelcast.client.impl.protocol.parameters.MapEntriesWithPredicateParameters;
import com.hazelcast.client.impl.protocol.parameters.MapEntrySetParameters;
import com.hazelcast.client.impl.protocol.parameters.MapEvictAllParameters;
import com.hazelcast.client.impl.protocol.parameters.MapEvictParameters;
import com.hazelcast.client.impl.protocol.parameters.MapExecuteOnAllKeysParameters;
import com.hazelcast.client.impl.protocol.parameters.MapExecuteOnKeyParameters;
import com.hazelcast.client.impl.protocol.parameters.MapExecuteOnKeysParameters;
import com.hazelcast.client.impl.protocol.parameters.MapExecuteWithPredicateParameters;
import com.hazelcast.client.impl.protocol.parameters.MapFlushParameters;
import com.hazelcast.client.impl.protocol.parameters.MapForceUnlockParameters;
import com.hazelcast.client.impl.protocol.parameters.MapGetAllParameters;
import com.hazelcast.client.impl.protocol.parameters.MapGetAsyncParameters;
import com.hazelcast.client.impl.protocol.parameters.MapGetEntryViewParameters;
import com.hazelcast.client.impl.protocol.parameters.MapGetParameters;
import com.hazelcast.client.impl.protocol.parameters.MapIsEmptyParameters;
import com.hazelcast.client.impl.protocol.parameters.MapIsLockedParameters;
import com.hazelcast.client.impl.protocol.parameters.MapKeySetParameters;
import com.hazelcast.client.impl.protocol.parameters.MapKeySetWithPredicateParameters;
import com.hazelcast.client.impl.protocol.parameters.MapLoadAllParameters;
import com.hazelcast.client.impl.protocol.parameters.MapLoadGivenKeysParameters;
import com.hazelcast.client.impl.protocol.parameters.MapLockParameters;
import com.hazelcast.client.impl.protocol.parameters.MapPartitionLostEventParameters;
import com.hazelcast.client.impl.protocol.parameters.MapPutAllParameters;
import com.hazelcast.client.impl.protocol.parameters.MapPutAsyncParameters;
import com.hazelcast.client.impl.protocol.parameters.MapPutIfAbsentParameters;
import com.hazelcast.client.impl.protocol.parameters.MapPutParameters;
import com.hazelcast.client.impl.protocol.parameters.MapPutTransientParameters;
import com.hazelcast.client.impl.protocol.parameters.MapRemoveAsyncParameters;
import com.hazelcast.client.impl.protocol.parameters.MapRemoveEntryListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.MapRemoveIfSameParameters;
import com.hazelcast.client.impl.protocol.parameters.MapRemoveInterceptorParameters;
import com.hazelcast.client.impl.protocol.parameters.MapRemoveParameters;
import com.hazelcast.client.impl.protocol.parameters.MapReplaceIfSameParameters;
import com.hazelcast.client.impl.protocol.parameters.MapReplaceParameters;
import com.hazelcast.client.impl.protocol.parameters.MapSetParameters;
import com.hazelcast.client.impl.protocol.parameters.MapSizeParameters;
import com.hazelcast.client.impl.protocol.parameters.MapSubmitToKeyParameters;
import com.hazelcast.client.impl.protocol.parameters.MapTryLockParameters;
import com.hazelcast.client.impl.protocol.parameters.MapTryPutParameters;
import com.hazelcast.client.impl.protocol.parameters.MapTryRemoveParameters;
import com.hazelcast.client.impl.protocol.parameters.MapUnlockParameters;
import com.hazelcast.client.impl.protocol.parameters.MapValuesParameters;
import com.hazelcast.client.impl.protocol.parameters.MapValuesWithPredicateParameters;
import com.hazelcast.client.nearcache.ClientHeapNearCache;
import com.hazelcast.client.nearcache.ClientNearCache;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapPartitionLostEvent;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapters;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PagingPredicateAccessor;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.SortedQueryResultSet;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.executor.CompletedFuture;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ClientMapProxy<K, V>
extends ClientProxy
implements IMap<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private final String name;
    private final AtomicBoolean nearCacheInitialized = new AtomicBoolean();
    private volatile ClientHeapNearCache<Data> nearCache;

    public ClientMapProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    public boolean containsKey(Object key) {
        Object cached;
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        this.initNearCache();
        Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null) {
            return !cached.equals(ClientNearCache.NULL_OBJECT);
        }
        ClientMessage message = MapContainsKeyParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage result = (ClientMessage)this.invoke(message, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)result);
        return resultParameters.result;
    }

    public boolean containsValue(Object value) {
        Preconditions.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        ClientMessage request = MapContainsValueParameters.encode((String)this.name, (Data)valueData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public V get(Object key) {
        Object cached;
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        this.initNearCache();
        Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null) {
            if (cached.equals(ClientHeapNearCache.NULL_OBJECT)) {
                return null;
            }
            return (V)cached;
        }
        ClientMessage request = MapGetParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)response);
        Object result = this.toObject(resultParameters.result);
        if (this.nearCache != null) {
            this.nearCache.put(keyData, result);
        }
        return (V)result;
    }

    public V put(K key, V value) {
        return this.put(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public V remove(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapRemoveParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)response);
        return (V)this.toObject(resultParameters.result);
    }

    public boolean remove(Object key, Object value) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapRemoveIfSameParameters.encode((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public void delete(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapDeleteParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        this.invoke(request, keyData);
    }

    public void flush() {
        ClientMessage request = MapFlushParameters.encode((String)this.name);
        this.invoke(request);
    }

    public Future<V> getAsync(K key) {
        Object cached;
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        this.initNearCache();
        final Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null && !ClientNearCache.NULL_OBJECT.equals(cached)) {
            return new CompletedFuture(this.getContext().getSerializationService(), cached, this.getContext().getExecutionService().getAsyncExecutor());
        }
        ClientMessage request = MapGetAsyncParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        try {
            ICompletableFuture future = this.invokeOnKeyOwner(request, keyData);
            DelegatingFuture delegatingFuture = new DelegatingFuture(future, this.getContext().getSerializationService());
            delegatingFuture.andThen(new ExecutionCallback<V>(){

                public void onResponse(V response) {
                    if (ClientMapProxy.this.nearCache != null) {
                        ClientMapProxy.this.nearCache.put(keyData, response);
                    }
                }

                public void onFailure(Throwable t) {
                }
            });
            return delegatingFuture;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private ICompletableFuture invokeOnKeyOwner(ClientMessage request, Data keyData) {
        int partitionId = this.getContext().getPartitionService().getPartitionId(keyData);
        ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), request, partitionId);
        return clientInvocation.invoke();
    }

    public Future<V> putAsync(K key, V value) {
        return this.putAsync(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public Future<V> putAsync(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapPutAsyncParameters.encode((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(ttl, timeunit));
        try {
            ICompletableFuture future = this.invokeOnKeyOwner(request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Future<V> removeAsync(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapRemoveAsyncParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        try {
            ICompletableFuture future = this.invokeOnKeyOwner(request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapTryRemoveParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)timeunit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapTryPutParameters.encode((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)timeunit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapPutParameters.encode((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(ttl, timeunit));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)response);
        return (V)this.toObject(resultParameters.result);
    }

    public void putTransient(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapPutTransientParameters.encode((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(ttl, timeunit));
        this.invoke(request, keyData);
    }

    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapPutIfAbsentParameters.encode((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(ttl, timeunit));
        ClientMessage result = (ClientMessage)this.invoke(request, keyData);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)result);
        return (V)this.toObject(resultParameters.result);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(oldValue, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(newValue, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapReplaceIfSameParameters.encode((String)this.name, (Data)keyData, (Data)oldValueData, (Data)newValueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public V replace(K key, V value) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapReplaceParameters.encode((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)response);
        return (V)this.toObject(resultParameters.result);
    }

    public void set(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapSetParameters.encode((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(ttl, timeunit));
        this.invoke(request, keyData);
    }

    public void lock(K key) {
        this.lock(key, -1L, TimeUnit.MILLISECONDS);
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapLockParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(leaseTime, timeUnit));
        this.invoke(request, keyData);
    }

    public boolean isLocked(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapIsLockedParameters.encode((String)this.name, (Data)keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean tryLock(K key) {
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapTryLockParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(time, timeunit));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public void unlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapUnlockParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        this.invoke(request, keyData);
    }

    public void forceUnlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapForceUnlockParameters.encode((String)this.name, (Data)keyData);
        this.invoke(request, keyData);
    }

    public String addLocalEntryListener(MapListener listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(EntryListener listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addInterceptor(MapInterceptor interceptor) {
        Data data = this.toData(interceptor);
        ClientMessage request = MapAddInterceptorParameters.encode((String)this.name, (Data)data);
        ClientMessage response = (ClientMessage)this.invoke(request);
        AddListenerResultParameters resultParameters = AddListenerResultParameters.decode((ClientMessage)response);
        return resultParameters.registrationId;
    }

    public void removeInterceptor(String id) {
        ClientMessage request = MapRemoveInterceptorParameters.encode((String)this.name, (String)id);
        this.invoke(request);
    }

    public String addEntryListener(MapListener listener, boolean includeValue) {
        ClientMessage request = MapAddEntryListenerParameters.encode((String)this.name, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        return this.listen(request, handler);
    }

    public String addEntryListener(EntryListener listener, boolean includeValue) {
        ClientMessage request = MapAddEntryListenerParameters.encode((String)this.name, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        return this.listen(request, handler);
    }

    public boolean removeEntryListener(String id) {
        ClientMessage request = MapRemoveEntryListenerParameters.encode((String)this.name, (String)id);
        return this.stopListening(request, id);
    }

    public String addPartitionLostListener(MapPartitionLostListener listener) {
        ClientMessage request = MapAddPartitionLostListenerParameters.encode((String)this.name);
        ClientMapPartitionLostEventHandler handler = new ClientMapPartitionLostEventHandler(listener);
        return this.listen(request, handler);
    }

    public boolean removePartitionLostListener(String id) {
        ClientMessage request = MapRemoveEntryListenerParameters.encode((String)this.name, (String)id);
        return this.stopListening(request, id);
    }

    public String addEntryListener(MapListener listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        ClientMessage request = MapAddEntryListenerToKeyParameters.encode((String)this.name, (Data)keyData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        return this.listen(request, keyData, handler);
    }

    public String addEntryListener(EntryListener listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        ClientMessage request = MapAddEntryListenerToKeyParameters.encode((String)this.name, (Data)keyData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        return this.listen(request, keyData, handler);
    }

    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        Data predicateData = this.toData(predicate);
        ClientMessage request = MapAddEntryListenerToKeyWithPredicateParameters.encode((String)this.name, (Data)keyData, (Data)predicateData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        return this.listen(request, keyData, handler);
    }

    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        Data predicateData = this.toData(predicate);
        ClientMessage request = MapAddEntryListenerToKeyWithPredicateParameters.encode((String)this.name, (Data)keyData, (Data)predicateData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        return this.listen(request, keyData, handler);
    }

    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Data predicateData = this.toData(predicate);
        ClientMessage request = MapAddEntryListenerWithPredicateParameters.encode((String)this.name, (Data)predicateData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        return this.listen(request, null, handler);
    }

    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Data predicateData = this.toData(predicate);
        ClientMessage request = MapAddEntryListenerWithPredicateParameters.encode((String)this.name, (Data)predicateData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        return this.listen(request, null, handler);
    }

    public EntryView<K, V> getEntryView(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapGetEntryViewParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        EntryViewParameters parameters = EntryViewParameters.decode((ClientMessage)response);
        SimpleEntryView entryView = new SimpleEntryView();
        SimpleEntryView dataEntryView = parameters.dataEntryView;
        if (dataEntryView == null) {
            return null;
        }
        entryView.setKey(this.toObject(dataEntryView.getKey()));
        entryView.setValue(this.toObject(dataEntryView.getValue()));
        entryView.setCost(dataEntryView.getCost());
        entryView.setCreationTime(dataEntryView.getCreationTime());
        entryView.setExpirationTime(dataEntryView.getExpirationTime());
        entryView.setHits(dataEntryView.getHits());
        entryView.setLastAccessTime(dataEntryView.getLastAccessTime());
        entryView.setLastStoredTime(dataEntryView.getLastStoredTime());
        entryView.setLastUpdateTime(dataEntryView.getLastUpdateTime());
        entryView.setVersion(dataEntryView.getVersion());
        entryView.setEvictionCriteriaNumber(dataEntryView.getEvictionCriteriaNumber());
        entryView.setTtl(dataEntryView.getTtl());
        return entryView;
    }

    public boolean evict(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapEvictParameters.encode((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public void evictAll() {
        this.clearNearCache();
        ClientMessage request = MapEvictAllParameters.encode((String)this.name);
        this.invoke(request);
    }

    public void loadAll(boolean replaceExistingValues) {
        if (replaceExistingValues) {
            this.clearNearCache();
        }
        ClientMessage request = MapLoadAllParameters.encode((String)this.name, (boolean)replaceExistingValues);
        this.invoke(request);
    }

    public void loadAll(Set<K> keys, boolean replaceExistingValues) {
        Preconditions.checkNotNull(keys, (String)"Parameter keys should not be null.");
        if (keys.isEmpty()) {
            return;
        }
        List<Data> dataKeys = this.convertKeysToData(keys);
        if (replaceExistingValues) {
            this.invalidateNearCache(dataKeys);
        }
        ClientMessage request = MapLoadGivenKeysParameters.encode((String)this.name, dataKeys, (boolean)replaceExistingValues);
        this.invoke(request);
    }

    private <K> List<Data> convertKeysToData(Set<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Data> dataKeys = new ArrayList<Data>(keys.size());
        for (K key : keys) {
            Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
            Data dataKey = this.toData(key);
            dataKeys.add(dataKey);
        }
        return dataKeys;
    }

    public Set<K> keySet() {
        ClientMessage request = MapKeySetParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection result = resultParameters.result;
        HashSet keySet = new HashSet(result.size());
        for (Data data : result) {
            Object key = this.toObject(data);
            keySet.add(key);
        }
        return keySet;
    }

    public Map<K, V> getAll(Set<K> keys) {
        this.initNearCache();
        HashSet<Data> keySet = new HashSet<Data>(keys.size());
        HashMap result = new HashMap();
        for (Object key : keys) {
            keySet.add(this.toData(key));
        }
        if (this.nearCache != null) {
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                Object key;
                key = (Data)iterator.next();
                Object cached = this.nearCache.get((Data)key);
                if (cached == null || ClientHeapNearCache.NULL_OBJECT.equals(cached)) continue;
                result.put(this.toObject(key), cached);
                iterator.remove();
            }
        }
        if (keySet.isEmpty()) {
            return result;
        }
        ClientMessage request = MapGetAllParameters.encode((String)this.name, keySet);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataEntryListResultParameters resultParameters = DataEntryListResultParameters.decode((ClientMessage)response);
        int size = resultParameters.keys.size();
        for (int i = 0; i < size; ++i) {
            Data dataKey = (Data)resultParameters.keys.get(i);
            Object value = this.toObject(resultParameters.values.get(i));
            Object key = this.toObject(dataKey);
            result.put(key, value);
            if (this.nearCache == null) continue;
            this.nearCache.put(dataKey, value);
        }
        return result;
    }

    public Collection<V> values() {
        ClientMessage request = MapValuesParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection collectionData = resultParameters.result;
        ArrayList collection = new ArrayList(collectionData.size());
        for (Data data : collectionData) {
            Object value = this.toObject(data);
            collection.add(value);
        }
        return collection;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = MapEntrySetParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataEntryListResultParameters resultParameters = DataEntryListResultParameters.decode((ClientMessage)response);
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        int size = resultParameters.keys.size();
        for (int i = 0; i < size; ++i) {
            Data keyData = (Data)resultParameters.keys.get(i);
            Data valueData = (Data)resultParameters.values.get(i);
            Object key = this.toObject(keyData);
            Object value = this.toObject(valueData);
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        return entrySet;
    }

    public Set<K> keySet(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.KEY);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.keySet((Predicate)pagingPredicate);
                pagingPredicate.nextPage();
            }
        }
        ClientMessage request = MapKeySetWithPredicateParameters.encode((String)this.name, (Data)this.toData(predicate));
        if (pagingPredicate == null) {
            ClientMessage response = (ClientMessage)this.invoke(request);
            DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
            HashSet keySet = new HashSet();
            for (Data o : resultParameters.result) {
                Object key = this.toObject(o);
                keySet.add(key);
            }
            return keySet;
        }
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataEntryListResultParameters resultParameters = DataEntryListResultParameters.decode((ClientMessage)response);
        Comparator comparator = SortingUtil.newComparator((Comparator)pagingPredicate.getComparator(), (IterationType)IterationType.KEY);
        SortedQueryResultSet sortedResult = new SortedQueryResultSet(comparator, IterationType.KEY, pagingPredicate.getPageSize());
        int size = resultParameters.keys.size();
        for (int i = 0; i < size; ++i) {
            Data keyData = (Data)resultParameters.keys.get(i);
            Data valueData = (Data)resultParameters.values.get(i);
            Object key = this.toObject(keyData);
            Object value = this.toObject(valueData);
            sortedResult.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        PagingPredicateAccessor.setPagingPredicateAnchor((PagingPredicate)pagingPredicate, (Map.Entry)sortedResult.last());
        return sortedResult;
    }

    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.ENTRY);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.entrySet((Predicate)pagingPredicate);
                pagingPredicate.nextPage();
            }
        }
        ClientMessage request = MapEntriesWithPredicateParameters.encode((String)this.name, (Data)this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataEntryListResultParameters resultParameters = DataEntryListResultParameters.decode((ClientMessage)response);
        SortedQueryResultSet entrySet = pagingPredicate == null ? new HashSet(resultParameters.keys.size()) : new SortedQueryResultSet(pagingPredicate.getComparator(), IterationType.ENTRY, pagingPredicate.getPageSize());
        for (int i = 0; i < resultParameters.keys.size(); ++i) {
            Data keyData = (Data)resultParameters.keys.get(i);
            Data valueData = (Data)resultParameters.values.get(i);
            Object key = this.toObject(keyData);
            Object value = this.toObject(valueData);
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        if (pagingPredicate != null) {
            PagingPredicateAccessor.setPagingPredicateAnchor((PagingPredicate)pagingPredicate, (Map.Entry)entrySet.last());
        }
        return entrySet;
    }

    public Collection<V> values(Predicate predicate) {
        if (predicate instanceof PagingPredicate) {
            return this.valuesForPagingPredicate((PagingPredicate)predicate);
        }
        ClientMessage request = MapValuesWithPredicateParameters.encode((String)this.name, (Data)this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection result = resultParameters.result;
        ArrayList values = new ArrayList(result.size());
        for (Data data : result) {
            Object value = this.toObject(data);
            values.add(value);
        }
        return values;
    }

    private Collection<V> valuesForPagingPredicate(PagingPredicate pagingPredicate) {
        pagingPredicate.setIterationType(IterationType.VALUE);
        if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
            pagingPredicate.previousPage();
            this.values((Predicate)pagingPredicate);
            pagingPredicate.nextPage();
        }
        ClientMessage request = MapValuesWithPredicateParameters.encode((String)this.name, (Data)this.toData(pagingPredicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataEntryListResultParameters resultParameters = DataEntryListResultParameters.decode((ClientMessage)response);
        int size = resultParameters.keys.size();
        List valueEntryList = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Data keyData = (Data)resultParameters.keys.get(i);
            Data valueData = (Data)resultParameters.values.get(i);
            Object t = this.toObject(keyData);
            Object value = this.toObject(valueData);
            valueEntryList.add(new AbstractMap.SimpleImmutableEntry(t, value));
        }
        Collections.sort(valueEntryList, SortingUtil.newComparator((Comparator)pagingPredicate.getComparator(), (IterationType)IterationType.VALUE));
        if (valueEntryList.size() > pagingPredicate.getPageSize()) {
            valueEntryList = valueEntryList.subList(0, pagingPredicate.getPageSize());
        }
        Map.Entry anchor = null;
        if (valueEntryList.size() != 0) {
            anchor = (Map.Entry)valueEntryList.get(valueEntryList.size() - 1);
        }
        PagingPredicateAccessor.setPagingPredicateAnchor((PagingPredicate)pagingPredicate, anchor);
        ArrayList values = new ArrayList(valueEntryList.size());
        for (Map.Entry entry : valueEntryList) {
            values.add(entry.getValue());
        }
        return values;
    }

    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public void addIndex(String attribute, boolean ordered) {
        ClientMessage request = MapAddIndexParameters.encode((String)this.name, (String)attribute, (boolean)ordered);
        this.invoke(request);
    }

    public LocalMapStats getLocalMapStats() {
        this.initNearCache();
        LocalMapStatsImpl localMapStats = new LocalMapStatsImpl();
        if (this.nearCache != null) {
            localMapStats.setNearCacheStats(this.nearCache.getNearCacheStats());
        }
        return localMapStats;
    }

    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapExecuteOnKeyParameters.encode((String)this.name, (Data)this.toData(entryProcessor), (Data)keyData);
        return this.invoke(request, keyData);
    }

    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapSubmitToKeyParameters.encode((String)this.name, (Data)this.toData(entryProcessor), (Data)keyData);
        try {
            ICompletableFuture future = this.invokeOnKeyOwner(request, keyData);
            future.andThen(callback);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Future submitToKey(K key, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapSubmitToKeyParameters.encode((String)this.name, (Data)this.toData(entryProcessor), (Data)keyData);
        try {
            ICompletableFuture future = this.invokeOnKeyOwner(request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
        ClientMessage request = MapExecuteOnAllKeysParameters.encode((String)this.name, (Data)this.toData(entryProcessor));
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataEntryListResultParameters resultParameters = DataEntryListResultParameters.decode((ClientMessage)response);
        int size = resultParameters.keys.size();
        HashMap result = new HashMap();
        for (int i = 0; i < size; ++i) {
            Data keyData = (Data)resultParameters.keys.get(i);
            Data valueData = (Data)resultParameters.values.get(i);
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        ClientMessage request = MapExecuteWithPredicateParameters.encode((String)this.name, (Data)this.toData(entryProcessor), (Data)this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataEntryListResultParameters resultParameters = DataEntryListResultParameters.decode((ClientMessage)response);
        int size = resultParameters.keys.size();
        HashMap result = new HashMap();
        for (int i = 0; i < size; ++i) {
            Data keyData = (Data)resultParameters.keys.get(i);
            Data valueData = (Data)resultParameters.values.get(i);
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getContext().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-map-" + this.getName());
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            Preconditions.isNotNull((Object)jobTracker, (String)"jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMap((IMap)this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory != null ? mappingJob.combiner(combinerFactory).reducer(reducerFactory) : mappingJob.reducer(reducerFactory);
            JobCompletableFuture future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException((Throwable)e);
        }
    }

    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        HashSet<Data> dataKeys = new HashSet<Data>(keys.size());
        for (K key : keys) {
            dataKeys.add(this.toData(key));
        }
        ClientMessage request = MapExecuteOnKeysParameters.encode((String)this.name, (Data)this.toData(entryProcessor), dataKeys);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataEntryListResultParameters resultParameters = DataEntryListResultParameters.decode((ClientMessage)response);
        int size = resultParameters.keys.size();
        HashMap result = new HashMap();
        for (int i = 0; i < size; ++i) {
            Data keyData = (Data)resultParameters.keys.get(i);
            Data valueData = (Data)resultParameters.values.get(i);
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    public void set(K key, V value) {
        this.set(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public int size() {
        ClientMessage request = MapSizeParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean isEmpty() {
        ClientMessage request = MapIsEmptyParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        int len = m.size();
        ArrayList<Data> keys = new ArrayList<Data>(len);
        ArrayList<Data> values = new ArrayList<Data>(len);
        for (Map.Entry<K, V> entry : m.entrySet()) {
            Data keyData = this.toData(entry.getKey());
            this.invalidateNearCache(keyData);
            keys.add(keyData);
            values.add(this.toData(entry.getValue()));
        }
        ClientMessage request = MapPutAllParameters.encode((String)this.name, keys, values);
        this.invoke(request);
    }

    public void clear() {
        ClientMessage request = MapClearParameters.encode((String)this.name);
        this.invalidateNearCache();
        this.invoke(request);
    }

    @Override
    protected void onDestroy() {
        this.destroyNearCache();
    }

    private void destroyNearCache() {
        if (this.nearCache != null) {
            this.removeNearCacheInvalidationListener();
            this.nearCache.destroy();
        }
    }

    @Override
    protected void onShutdown() {
        this.destroyNearCache();
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<ClientMessage> createHandler(Object listener, boolean includeValue) {
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        return new ClientMapEventHandler(listenerAdaptor, includeValue);
    }

    private void invalidateNearCache(Data key) {
        if (this.nearCache != null) {
            this.nearCache.invalidate(key);
        }
    }

    private void invalidateNearCache() {
        if (this.nearCache != null) {
            this.nearCache.clear();
        }
    }

    private void invalidateNearCache(Collection<Data> keys) {
        if (this.nearCache != null) {
            if (keys == null || keys.isEmpty()) {
                return;
            }
            for (Data key : keys) {
                this.nearCache.invalidate(key);
            }
        }
    }

    private void clearNearCache() {
        if (this.nearCache != null) {
            this.nearCache.clear();
        }
    }

    private void initNearCache() {
        if (this.nearCacheInitialized.compareAndSet(false, true)) {
            NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.name);
            if (nearCacheConfig == null) {
                return;
            }
            this.nearCache = new ClientHeapNearCache(this.name, this.getContext(), nearCacheConfig);
            if (this.nearCache.isInvalidateOnChange()) {
                this.addNearCacheInvalidateListener();
            }
        }
    }

    private void addNearCacheInvalidateListener() {
        try {
            ClientMessage request = MapAddNearCacheEntryListenerParameters.encode((String)this.name, (boolean)false);
            EventHandler<ClientMessage> handler = new EventHandler<ClientMessage>(){

                @Override
                public void handle(ClientMessage eventMessage) {
                    EntryEventParameters event = EntryEventParameters.decode((ClientMessage)eventMessage);
                    EntryEventType entryEventType = EntryEventType.getByType((int)event.eventType);
                    switch (entryEventType) {
                        case ADDED: 
                        case REMOVED: 
                        case UPDATED: 
                        case EVICTED: 
                        case MERGED: {
                            ClientMapProxy.this.nearCache.remove(event.key);
                            break;
                        }
                        case EVICT_ALL: 
                        case CLEAR_ALL: {
                            ClientMapProxy.this.nearCache.clear();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Not a known event type " + entryEventType);
                        }
                    }
                }

                @Override
                public void beforeListenerRegister() {
                    ClientMapProxy.this.nearCache.clear();
                }

                @Override
                public void onListenerRegister() {
                    ClientMapProxy.this.nearCache.clear();
                }
            };
            String registrationId = this.getContext().getListenerService().startListening(request, null, handler);
            this.nearCache.setId(registrationId);
        }
        catch (Exception e) {
            Logger.getLogger(ClientHeapNearCache.class).severe("-----------------\n Near Cache is not initialized!!! \n-----------------", (Throwable)e);
        }
    }

    private void removeNearCacheInvalidationListener() {
        if (this.nearCache != null && this.nearCache.getId() != null) {
            String registrationId = this.nearCache.getId();
            ClientMessage request = MapRemoveEntryListenerParameters.encode((String)this.name, (String)registrationId);
            this.getContext().getListenerService().stopListening(request, registrationId);
        }
    }

    public String toString() {
        return "IMap{name='" + this.getName() + '\'' + '}';
    }

    private class ClientMapPartitionLostEventHandler
    implements EventHandler<ClientMessage> {
        private MapPartitionLostListener listener;

        public ClientMapPartitionLostEventHandler(MapPartitionLostListener listener) {
            this.listener = listener;
        }

        @Override
        public void handle(ClientMessage eventMessage) {
            MapPartitionLostEventParameters event = MapPartitionLostEventParameters.decode((ClientMessage)eventMessage);
            MemberImpl member = ClientMapProxy.this.getContext().getClusterService().getMember(event.uuid);
            this.listener.partitionLost(new MapPartitionLostEvent((Object)ClientMapProxy.this.name, (Member)member, -1, event.partitionId));
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }

    private class ClientMapEventHandler
    implements EventHandler<ClientMessage> {
        private final ListenerAdapter listenerAdapter;
        private final boolean includeValue;

        public ClientMapEventHandler(ListenerAdapter listenerAdapter, boolean includeValue) {
            this.listenerAdapter = listenerAdapter;
            this.includeValue = includeValue;
        }

        @Override
        public void handle(ClientMessage clientMessage) {
            EntryEventParameters event = EntryEventParameters.decode((ClientMessage)clientMessage);
            MemberImpl member = ClientMapProxy.this.getContext().getClusterService().getMember(event.uuid);
            IMapEvent iMapEvent = this.createIMapEvent(event, (Member)member);
            this.listenerAdapter.onEvent(iMapEvent);
        }

        private IMapEvent createIMapEvent(EntryEventParameters event, Member member) {
            MapEvent iMapEvent;
            EntryEventType entryEventType = EntryEventType.getByType((int)event.eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: 
                case MERGED: {
                    iMapEvent = this.createEntryEvent(event, member);
                    break;
                }
                case EVICT_ALL: 
                case CLEAR_ALL: {
                    iMapEvent = this.createMapEvent(event, member);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + entryEventType);
                }
            }
            return iMapEvent;
        }

        private MapEvent createMapEvent(EntryEventParameters event, Member member) {
            return new MapEvent((Object)ClientMapProxy.this.name, member, event.eventType, event.numberOfAffectedEntries);
        }

        private EntryEvent<K, V> createEntryEvent(EntryEventParameters event, Member member) {
            Object value = null;
            Object oldValue = null;
            Object mergingValue = null;
            if (this.includeValue) {
                value = ClientMapProxy.this.toObject(event.value);
                oldValue = ClientMapProxy.this.toObject(event.oldValue);
                mergingValue = ClientMapProxy.this.toObject(event.mergingValue);
            }
            Object key = ClientMapProxy.this.toObject(event.key);
            return new EntryEvent((Object)ClientMapProxy.this.name, member, event.eventType, key, oldValue, value, mergingValue);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

