/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.LockForceUnlockParameters;
import com.hazelcast.client.impl.protocol.parameters.LockGetLockCountParameters;
import com.hazelcast.client.impl.protocol.parameters.LockGetRemainingLeaseTimeParameters;
import com.hazelcast.client.impl.protocol.parameters.LockIsLockedByCurrentThreadParameters;
import com.hazelcast.client.impl.protocol.parameters.LockIsLockedParameters;
import com.hazelcast.client.impl.protocol.parameters.LockLockParameters;
import com.hazelcast.client.impl.protocol.parameters.LockTryLockParameters;
import com.hazelcast.client.impl.protocol.parameters.LockUnlockParameters;
import com.hazelcast.client.impl.protocol.parameters.LongResultParameters;
import com.hazelcast.client.proxy.ClientConditionProxy;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.core.ICondition;
import com.hazelcast.core.ILock;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class ClientLockProxy
extends ClientProxy
implements ILock {
    private volatile Data key;

    public ClientLockProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
    }

    @Deprecated
    public Object getKey() {
        return this.getName();
    }

    public boolean isLocked() {
        ClientMessage request = LockIsLockedParameters.encode((String)this.getName());
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public boolean isLockedByCurrentThread() {
        ClientMessage request = LockIsLockedByCurrentThreadParameters.encode((String)this.getName(), (long)ThreadUtil.getThreadId());
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public int getLockCount() {
        ClientMessage request = LockGetLockCountParameters.encode((String)this.getName());
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public long getRemainingLeaseTime() {
        ClientMessage request = LockGetRemainingLeaseTimeParameters.encode((String)this.getName());
        LongResultParameters resultParameters = LongResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public void lock(long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkPositive((long)leaseTime, (String)"leaseTime should be positive");
        ClientMessage request = LockLockParameters.encode((String)this.getName(), (long)this.getTimeInMillis(leaseTime, timeUnit), (long)ThreadUtil.getThreadId());
        this.invoke(request);
    }

    public void forceUnlock() {
        ClientMessage request = LockForceUnlockParameters.encode((String)this.getName());
        this.invoke(request);
    }

    public ICondition newCondition(String name) {
        return new ClientConditionProxy(this, name, this.getContext());
    }

    public void lock() {
        this.lock(Long.MAX_VALUE, null);
    }

    public void lockInterruptibly() throws InterruptedException {
        ClientMessage request = LockLockParameters.encode((String)this.getName(), (long)Long.MAX_VALUE, (long)ThreadUtil.getThreadId());
        this.invokeInterruptibly(request, this.getKeyData());
    }

    public boolean tryLock() {
        try {
            return this.tryLock(0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        ClientMessage request = LockTryLockParameters.encode((String)this.getName(), (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(time, unit));
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public void unlock() {
        ClientMessage request = LockUnlockParameters.encode((String)this.getName(), (long)ThreadUtil.getThreadId());
        this.invoke(request);
    }

    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    private Data getKeyData() {
        if (this.key == null) {
            this.key = this.toData(this.getName());
        }
        return this.key;
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getKeyData());
    }

    public String toString() {
        return "ILock{name='" + this.getName() + '\'' + '}';
    }
}

