/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.DataCollectionResultParameters;
import com.hazelcast.client.impl.protocol.parameters.GenericResultParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.impl.protocol.parameters.ItemEventParameters;
import com.hazelcast.client.impl.protocol.parameters.ListAddAllParameters;
import com.hazelcast.client.impl.protocol.parameters.ListAddAllWithIndexParameters;
import com.hazelcast.client.impl.protocol.parameters.ListAddListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.ListAddParameters;
import com.hazelcast.client.impl.protocol.parameters.ListAddWithIndexParameters;
import com.hazelcast.client.impl.protocol.parameters.ListClearParameters;
import com.hazelcast.client.impl.protocol.parameters.ListCompareAndRemoveAllParameters;
import com.hazelcast.client.impl.protocol.parameters.ListCompareAndRetainAllParameters;
import com.hazelcast.client.impl.protocol.parameters.ListContainsAllParameters;
import com.hazelcast.client.impl.protocol.parameters.ListContainsParameters;
import com.hazelcast.client.impl.protocol.parameters.ListGetAllParameters;
import com.hazelcast.client.impl.protocol.parameters.ListGetParameters;
import com.hazelcast.client.impl.protocol.parameters.ListIndexOfParameters;
import com.hazelcast.client.impl.protocol.parameters.ListIsEmptyParameters;
import com.hazelcast.client.impl.protocol.parameters.ListLastIndexOfParameters;
import com.hazelcast.client.impl.protocol.parameters.ListRemoveListenerParameters;
import com.hazelcast.client.impl.protocol.parameters.ListRemoveParameters;
import com.hazelcast.client.impl.protocol.parameters.ListRemoveWithIndexParameters;
import com.hazelcast.client.impl.protocol.parameters.ListSetParameters;
import com.hazelcast.client.impl.protocol.parameters.ListSizeParameters;
import com.hazelcast.client.impl.protocol.parameters.ListSubParameters;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.IList;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ClientListProxy<E>
extends ClientProxy
implements IList<E> {
    private final String name;

    public ClientListProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    public boolean addAll(int index, Collection<? extends E> c) {
        this.throwExceptionIfNull(c);
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        for (E e : c) {
            this.throwExceptionIfNull(e);
            valueList.add(this.toData(e));
        }
        ClientMessage request = ListAddAllWithIndexParameters.encode((String)this.name, (int)index, valueList);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public E get(int index) {
        ClientMessage request = ListGetParameters.encode((String)this.name, (int)index);
        ClientMessage response = (ClientMessage)this.invoke(request);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)response);
        return (E)this.toObject(resultParameters.result);
    }

    public E set(int index, E element) {
        this.throwExceptionIfNull(element);
        Data value = this.toData(element);
        ClientMessage request = ListSetParameters.encode((String)this.name, (int)index, (Data)value);
        ClientMessage response = (ClientMessage)this.invoke(request);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)response);
        return (E)this.toObject(resultParameters.result);
    }

    public void add(int index, E element) {
        this.throwExceptionIfNull(element);
        Data value = this.toData(element);
        ClientMessage request = ListAddWithIndexParameters.encode((String)this.name, (int)index, (Data)value);
        this.invoke(request);
    }

    public E remove(int index) {
        ClientMessage request = ListRemoveWithIndexParameters.encode((String)this.name, (int)index);
        ClientMessage response = (ClientMessage)this.invoke(request);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)response);
        return (E)this.toObject(resultParameters.result);
    }

    public int size() {
        ClientMessage request = ListSizeParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean isEmpty() {
        ClientMessage request = ListIsEmptyParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean contains(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = ListContainsParameters.encode((String)this.name, (Data)value);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.getAll()).iterator();
    }

    public Object[] toArray() {
        return this.getAll().toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.getAll().toArray(a);
    }

    public boolean add(E e) {
        this.throwExceptionIfNull(e);
        Data element = this.toData(e);
        ClientMessage request = ListAddParameters.encode((String)this.name, (Data)element);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean remove(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = ListRemoveParameters.encode((String)this.name, (Data)value);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean containsAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>(c.size());
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = ListContainsAllParameters.encode((String)this.name, valueSet);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean addAll(Collection<? extends E> c) {
        this.throwExceptionIfNull(c);
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        for (E e : c) {
            this.throwExceptionIfNull(e);
            valueList.add(this.toData(e));
        }
        ClientMessage request = ListAddAllParameters.encode((String)this.name, valueList);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean removeAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>();
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = ListCompareAndRemoveAllParameters.encode((String)this.name, valueSet);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public boolean retainAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>();
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = ListCompareAndRetainAllParameters.encode((String)this.name, valueSet);
        ClientMessage response = (ClientMessage)this.invoke(request);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public void clear() {
        ClientMessage request = ListClearParameters.encode((String)this.name);
        this.invoke(request);
    }

    public String addItemListener(final ItemListener<E> listener, final boolean includeValue) {
        ClientMessage request = ListAddListenerParameters.encode((String)this.name, (boolean)includeValue);
        EventHandler<ClientMessage> eventHandler = new EventHandler<ClientMessage>(){
            final SerializationService serializationService;
            final ClientClusterService clusterService;
            {
                this.serializationService = ClientListProxy.this.getContext().getSerializationService();
                this.clusterService = ClientListProxy.this.getContext().getClusterService();
            }

            @Override
            public void handle(ClientMessage message) {
                ItemEventParameters event = ItemEventParameters.decode((ClientMessage)message);
                Object item = includeValue ? this.serializationService.toObject((Object)event.item) : null;
                MemberImpl member = this.clusterService.getMember(event.uuid);
                ItemEvent itemEvent = new ItemEvent(ClientListProxy.this.name, event.eventType, item, (Member)member);
                if (event.eventType == ItemEventType.ADDED) {
                    listener.itemAdded(itemEvent);
                } else {
                    listener.itemRemoved(itemEvent);
                }
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
        return this.listen(request, this.getPartitionKey(), eventHandler);
    }

    public boolean removeItemListener(String registrationId) {
        ClientMessage request = ListRemoveListenerParameters.encode((String)this.name, (String)registrationId);
        return this.stopListening(request, registrationId);
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getPartitionKey());
    }

    private Collection<E> getAll() {
        ClientMessage request = ListGetAllParameters.encode((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection resultCollection = resultParameters.result;
        ArrayList list = new ArrayList(resultCollection.size());
        for (Data value : resultCollection) {
            list.add(this.toObject(value));
        }
        return list;
    }

    public int lastIndexOf(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = ListLastIndexOfParameters.encode((String)this.name, (Data)value);
        ClientMessage response = (ClientMessage)this.invoke(request);
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public int indexOf(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = ListIndexOfParameters.encode((String)this.name, (Data)value);
        ClientMessage response = (ClientMessage)this.invoke(request);
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)response);
        return resultParameters.result;
    }

    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<E> listIterator(int index) {
        return this.subList(-1, -1).listIterator(index);
    }

    public List<E> subList(int fromIndex, int toIndex) {
        ClientMessage request = ListSubParameters.encode((String)this.name, (int)fromIndex, (int)toIndex);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DataCollectionResultParameters resultParameters = DataCollectionResultParameters.decode((ClientMessage)response);
        Collection resultCollection = resultParameters.result;
        ArrayList list = new ArrayList(resultCollection.size());
        for (Data value : resultCollection) {
            list.add(this.toObject(value));
        }
        return list;
    }

    public String toString() {
        return "IList{name='" + this.getName() + '\'' + '}';
    }
}

