/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.CountDownLatchAwaitParameters;
import com.hazelcast.client.impl.protocol.parameters.CountDownLatchCountDownParameters;
import com.hazelcast.client.impl.protocol.parameters.CountDownLatchGetCountParameters;
import com.hazelcast.client.impl.protocol.parameters.CountDownLatchTrySetCountParameters;
import com.hazelcast.client.impl.protocol.parameters.IntResultParameters;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.nio.serialization.Data;
import java.util.concurrent.TimeUnit;

public class ClientCountDownLatchProxy
extends ClientProxy
implements ICountDownLatch {
    private volatile Data key;

    public ClientCountDownLatchProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        ClientMessage request = CountDownLatchAwaitParameters.encode((String)this.getName(), (long)this.getTimeInMillis(timeout, unit));
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public void countDown() {
        ClientMessage request = CountDownLatchCountDownParameters.encode((String)this.getName());
        this.invoke(request);
    }

    public int getCount() {
        ClientMessage request = CountDownLatchGetCountParameters.encode((String)this.getName());
        IntResultParameters resultParameters = IntResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public boolean trySetCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count can't be negative");
        }
        ClientMessage request = CountDownLatchTrySetCountParameters.encode((String)this.getName(), (int)count);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.toData(this.getName());
        }
        return this.key;
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getKey());
    }

    public String toString() {
        return "ICountDownLatch{name='" + this.getName() + '\'' + '}';
    }
}

