/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.AtomicReferenceAlterAndGetParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicReferenceAlterParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicReferenceApplyParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicReferenceClearParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicReferenceCompareAndSetParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicReferenceContainsParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicReferenceGetAndAlterParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicReferenceGetAndSetParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicReferenceGetParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicReferenceIsNullParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicReferenceSetAndGetParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicReferenceSetParameters;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.GenericResultParameters;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IFunction;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;

public class ClientAtomicReferenceProxy<E>
extends ClientProxy
implements IAtomicReference<E> {
    private final String name;
    private volatile Data key;

    public ClientAtomicReferenceProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    public <R> R apply(IFunction<E, R> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicReferenceApplyParameters.encode((String)this.name, (Data)this.toData(function));
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return (R)this.toObject(resultParameters.result);
    }

    public void alter(IFunction<E, E> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicReferenceAlterParameters.encode((String)this.name, (Data)this.toData(function));
        this.invoke(request);
    }

    public E alterAndGet(IFunction<E, E> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicReferenceAlterAndGetParameters.encode((String)this.name, (Data)this.toData(function));
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return (E)this.toObject(resultParameters.result);
    }

    public E getAndAlter(IFunction<E, E> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicReferenceGetAndAlterParameters.encode((String)this.name, (Data)this.toData(function));
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return (E)this.toObject(resultParameters.result);
    }

    public boolean compareAndSet(E expect, E update) {
        ClientMessage request = AtomicReferenceCompareAndSetParameters.encode((String)this.name, (Data)this.toData(expect), (Data)this.toData(update));
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public boolean contains(E expected) {
        ClientMessage request = AtomicReferenceContainsParameters.encode((String)this.name, (Data)this.toData(expected));
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public E get() {
        ClientMessage request = AtomicReferenceGetParameters.encode((String)this.name);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return (E)this.toObject(resultParameters.result);
    }

    public void set(E newValue) {
        ClientMessage request = AtomicReferenceSetParameters.encode((String)this.name, (Data)this.toData(newValue));
        this.invoke(request);
    }

    public void clear() {
        ClientMessage request = AtomicReferenceClearParameters.encode((String)this.name);
        this.invoke(request);
    }

    public E getAndSet(E newValue) {
        ClientMessage request = AtomicReferenceGetAndSetParameters.encode((String)this.name, (Data)this.toData(newValue));
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return (E)this.toObject(resultParameters.result);
    }

    public E setAndGet(E update) {
        ClientMessage request = AtomicReferenceSetAndGetParameters.encode((String)this.name, (Data)this.toData(update));
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return (E)this.toObject(resultParameters.result);
    }

    public boolean isNull() {
        ClientMessage request = AtomicReferenceIsNullParameters.encode((String)this.name);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getKey());
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.toData(this.name);
        }
        return this.key;
    }

    public String toString() {
        return "IAtomicReference{name='" + this.name + '\'' + '}';
    }
}

