/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.AtomicLongAddAndGetParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicLongAlterAndGetParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicLongAlterParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicLongApplyParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicLongCompareAndSetParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicLongGetAndAddParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicLongGetAndAlterParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicLongGetAndSetParameters;
import com.hazelcast.client.impl.protocol.parameters.AtomicLongSetParameters;
import com.hazelcast.client.impl.protocol.parameters.BooleanResultParameters;
import com.hazelcast.client.impl.protocol.parameters.GenericResultParameters;
import com.hazelcast.client.impl.protocol.parameters.LongResultParameters;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IFunction;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;

public class ClientAtomicLongProxy
extends ClientProxy
implements IAtomicLong {
    private final String name;
    private volatile Data key;

    public ClientAtomicLongProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    public <R> R apply(IFunction<Long, R> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicLongApplyParameters.encode((String)this.name, (Data)this.toData(function));
        ClientMessage response = (ClientMessage)this.invoke(request);
        GenericResultParameters resultParameters = GenericResultParameters.decode((ClientMessage)response);
        return (R)this.toObject(resultParameters.result);
    }

    public void alter(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicLongAlterParameters.encode((String)this.name, (Data)this.toData(function));
        this.invoke(request);
    }

    public long alterAndGet(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicLongAlterAndGetParameters.encode((String)this.name, (Data)this.toData(function));
        LongResultParameters resultParameters = LongResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public long getAndAlter(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicLongGetAndAlterParameters.encode((String)this.name, (Data)this.toData(function));
        LongResultParameters resultParameters = LongResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public long addAndGet(long delta) {
        ClientMessage request = AtomicLongAddAndGetParameters.encode((String)this.name, (long)delta);
        LongResultParameters resultParameters = LongResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public boolean compareAndSet(long expect, long update) {
        ClientMessage request = AtomicLongCompareAndSetParameters.encode((String)this.name, (long)expect, (long)update);
        BooleanResultParameters resultParameters = BooleanResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public long decrementAndGet() {
        return this.addAndGet(-1L);
    }

    public long get() {
        return this.getAndAdd(0L);
    }

    public long getAndAdd(long delta) {
        ClientMessage request = AtomicLongGetAndAddParameters.encode((String)this.name, (long)delta);
        LongResultParameters resultParameters = LongResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public long getAndSet(long newValue) {
        ClientMessage request = AtomicLongGetAndSetParameters.encode((String)this.name, (long)newValue);
        LongResultParameters resultParameters = LongResultParameters.decode((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.result;
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    public void set(long newValue) {
        ClientMessage request = AtomicLongSetParameters.encode((String)this.name, (long)newValue);
        this.invoke(request);
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getKey());
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.toData(this.name);
        }
        return this.key;
    }

    public String toString() {
        return "IAtomicLong{name='" + this.name + '\'' + '}';
    }
}

