/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.cache.impl.nearcache.NearCacheManager;
import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientProperties;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.DefaultClientExtension;
import com.hazelcast.client.impl.LifecycleServiceImpl;
import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.parameters.GetDistributedObjectParameters;
import com.hazelcast.client.impl.protocol.parameters.GetDistributedObjectResultParameters;
import com.hazelcast.client.proxy.ClientClusterProxy;
import com.hazelcast.client.proxy.PartitionServiceProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientTransactionManagerService;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.client.spi.impl.AwsAddressTranslator;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.ClientNonSmartInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.spi.impl.ClientSmartInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientTransactionManagerServiceImpl;
import com.hazelcast.client.spi.impl.DefaultAddressTranslator;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.concurrent.lock.LockProxy;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.quorum.QuorumService;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ServiceLoader;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class HazelcastClientInstanceImpl
implements HazelcastInstance {
    private static final AtomicInteger CLIENT_ID = new AtomicInteger();
    private static final ILogger LOGGER = Logger.getLogger(HazelcastClient.class);
    private static final short protocolVersion = 1;
    private final ClientProperties clientProperties;
    private final int id = CLIENT_ID.getAndIncrement();
    private final String instanceName;
    private final ClientConfig config;
    private final ThreadGroup threadGroup;
    private final LifecycleServiceImpl lifecycleService;
    private final SerializationService serializationService;
    private final ClientConnectionManager connectionManager;
    private final ClientClusterServiceImpl clusterService;
    private final ClientPartitionServiceImpl partitionService;
    private final ClientInvocationService invocationService;
    private final ClientExecutionServiceImpl executionService;
    private final ClientListenerServiceImpl listenerService;
    private final ClientTransactionManagerService transactionManager;
    private final NearCacheManager nearCacheManager;
    private final ProxyManager proxyManager;
    private final ConcurrentMap<String, Object> userContext;
    private final LoadBalancer loadBalancer;
    private final ClientExtension clientExtension;
    private final Credentials credentials;

    public HazelcastClientInstanceImpl(ClientConfig config) {
        this.config = config;
        GroupConfig groupConfig = config.getGroupConfig();
        this.instanceName = "hz.client_" + this.id + (groupConfig != null ? "_" + groupConfig.getName() : "");
        this.clientExtension = this.createClientInitializer(config.getClassLoader());
        this.clientExtension.beforeStart(this);
        this.credentials = this.initCredentials(config);
        this.threadGroup = new ThreadGroup(this.instanceName);
        this.lifecycleService = new LifecycleServiceImpl(this);
        this.clientProperties = new ClientProperties(config);
        this.serializationService = this.clientExtension.createSerializationService();
        this.proxyManager = new ProxyManager(this);
        this.executionService = this.initExecutorService();
        this.loadBalancer = this.initLoadBalancer(config);
        this.transactionManager = new ClientTransactionManagerServiceImpl(this, this.loadBalancer);
        this.partitionService = new ClientPartitionServiceImpl(this);
        this.connectionManager = this.initClientConnectionManager();
        this.clusterService = new ClientClusterServiceImpl(this);
        this.invocationService = this.initInvocationService();
        this.listenerService = this.initListenerService();
        this.userContext = new ConcurrentHashMap<String, Object>();
        this.nearCacheManager = this.clientExtension.createNearCacheManager();
        this.proxyManager.init(config);
    }

    private LoadBalancer initLoadBalancer(ClientConfig config) {
        LoadBalancer lb = config.getLoadBalancer();
        if (lb == null) {
            lb = new RoundRobinLB();
        }
        return lb;
    }

    private Credentials initCredentials(ClientConfig config) {
        String credentialsClassname;
        GroupConfig groupConfig = config.getGroupConfig();
        ClientSecurityConfig securityConfig = config.getSecurityConfig();
        Credentials c = securityConfig.getCredentials();
        if (c == null && (credentialsClassname = securityConfig.getCredentialsClassname()) != null) {
            try {
                c = (Credentials)ClassLoaderUtil.newInstance((ClassLoader)config.getClassLoader(), (String)credentialsClassname);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        if (c == null) {
            c = new UsernamePasswordCredentials(groupConfig.getName(), groupConfig.getPassword());
        }
        return c;
    }

    private ClientInvocationService initInvocationService() {
        ClientNetworkConfig networkConfig = this.config.getNetworkConfig();
        if (networkConfig.isSmartRouting()) {
            return new ClientSmartInvocationServiceImpl(this, this.loadBalancer);
        }
        return new ClientNonSmartInvocationServiceImpl(this);
    }

    public int getId() {
        return this.id;
    }

    private ClientExtension createClientInitializer(ClassLoader classLoader) {
        try {
            String factoryId = ClientExtension.class.getName();
            Iterator iter = ServiceLoader.iterator(ClientExtension.class, (String)factoryId, (ClassLoader)classLoader);
            while (iter.hasNext()) {
                ClientExtension initializer = (ClientExtension)iter.next();
                if (initializer.getClass().equals(DefaultClientExtension.class)) continue;
                return initializer;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new DefaultClientExtension();
    }

    private ClientListenerServiceImpl initListenerService() {
        int eventQueueCapacity = this.clientProperties.getEventQueueCapacity().getInteger();
        int eventThreadCount = this.clientProperties.getEventThreadCount().getInteger();
        return new ClientListenerServiceImpl(this, eventThreadCount, eventQueueCapacity);
    }

    private ClientExecutionServiceImpl initExecutorService() {
        return new ClientExecutionServiceImpl(this.instanceName, this.threadGroup, this.config.getClassLoader(), this.config.getExecutorPoolSize());
    }

    public void start() {
        this.lifecycleService.setStarted();
        this.connectionManager.start();
        try {
            this.clusterService.start();
        }
        catch (Exception e) {
            this.lifecycleService.shutdown();
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        this.loadBalancer.init(this.getCluster(), this.config);
        this.partitionService.start();
        this.clientExtension.afterStart(this);
    }

    ClientConnectionManager initClientConnectionManager() {
        AddressTranslator addressTranslator;
        ClientAwsConfig awsConfig = this.config.getNetworkConfig().getAwsConfig();
        if (awsConfig != null && awsConfig.isEnabled()) {
            try {
                addressTranslator = new AwsAddressTranslator(awsConfig);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.WARNING, "hazelcast-cloud.jar might be missing!");
                throw e;
            }
        } else {
            addressTranslator = new DefaultAddressTranslator();
        }
        return new ClientConnectionManagerImpl(this, addressTranslator);
    }

    public HazelcastXAResource getXAResource() {
        return (HazelcastXAResource)this.getDistributedObject("hz:impl:xaService", "hz:impl:xaService");
    }

    public Config getConfig() {
        throw new UnsupportedOperationException("Client cannot access cluster config!");
    }

    public ClientProperties getClientProperties() {
        return this.clientProperties;
    }

    public String getName() {
        return this.instanceName;
    }

    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getDistributedObject("hz:impl:queueService", name);
    }

    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getDistributedObject("hz:impl:topicService", name);
    }

    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getDistributedObject("hz:impl:setService", name);
    }

    public <E> IList<E> getList(String name) {
        return (IList)this.getDistributedObject("hz:impl:listService", name);
    }

    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getDistributedObject("hz:impl:mapService", name);
    }

    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getDistributedObject("hz:impl:multiMapService", name);
    }

    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        return (ReplicatedMap)this.getDistributedObject("hz:impl:replicatedMapService", name);
    }

    public JobTracker getJobTracker(String name) {
        return (JobTracker)this.getDistributedObject("hz:impl:mapReduceService", name);
    }

    public ILock getLock(String key) {
        return (ILock)this.getDistributedObject("hz:impl:lockService", key);
    }

    public <E> ITopic<E> getReliableTopic(String name) {
        return (ITopic)this.getDistributedObject("hz:impl:reliableTopicService", name);
    }

    @Deprecated
    public ILock getLock(Object key) {
        String name = LockProxy.convertToStringKey((Object)key, (SerializationService)this.serializationService);
        return (ILock)this.getDistributedObject("hz:impl:lockService", name);
    }

    public <E> Ringbuffer<E> getRingbuffer(String name) {
        return (Ringbuffer)this.getDistributedObject("hz:impl:ringbufferService", name);
    }

    public Cluster getCluster() {
        return new ClientClusterProxy(this.clusterService);
    }

    public Client getLocalEndpoint() {
        return this.clusterService.getLocalClient();
    }

    public IExecutorService getExecutorService(String name) {
        return (IExecutorService)this.getDistributedObject("hz:impl:executorService", name);
    }

    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(task);
    }

    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(options, task);
    }

    public TransactionContext newTransactionContext() {
        return this.transactionManager.newTransactionContext();
    }

    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.transactionManager.newTransactionContext(options);
    }

    public ClientTransactionManagerService getTransactionManager() {
        return this.transactionManager;
    }

    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getDistributedObject("hz:impl:idGeneratorService", name);
    }

    public IAtomicLong getAtomicLong(String name) {
        return (IAtomicLong)this.getDistributedObject("hz:impl:atomicLongService", name);
    }

    public <E> IAtomicReference<E> getAtomicReference(String name) {
        return (IAtomicReference)this.getDistributedObject("hz:impl:atomicReferenceService", name);
    }

    public ICountDownLatch getCountDownLatch(String name) {
        return (ICountDownLatch)this.getDistributedObject("hz:impl:countDownLatchService", name);
    }

    public ISemaphore getSemaphore(String name) {
        return (ISemaphore)this.getDistributedObject("hz:impl:semaphoreService", name);
    }

    public Collection<DistributedObject> getDistributedObjects() {
        try {
            ClientMessage request = GetDistributedObjectParameters.encode();
            ClientInvocationFuture future = new ClientInvocation(this, request).invoke();
            ClientMessage response = (ClientMessage)future.get();
            GetDistributedObjectResultParameters resultParameters = GetDistributedObjectResultParameters.decode((ClientMessage)response);
            Collection infoCollection = resultParameters.infoCollection;
            for (DistributedObjectInfo distributedObjectInfo : infoCollection) {
                this.getDistributedObject(distributedObjectInfo.getServiceName(), distributedObjectInfo.getName());
            }
            return this.proxyManager.getDistributedObjects();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.proxyManager.addDistributedObjectListener(distributedObjectListener);
    }

    public boolean removeDistributedObjectListener(String registrationId) {
        return this.proxyManager.removeDistributedObjectListener(registrationId);
    }

    public PartitionService getPartitionService() {
        return new PartitionServiceProxy(this.partitionService, this.listenerService);
    }

    public QuorumService getQuorumService() {
        throw new UnsupportedOperationException();
    }

    public ClientService getClientService() {
        throw new UnsupportedOperationException();
    }

    public LoggingService getLoggingService() {
        throw new UnsupportedOperationException();
    }

    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    @Deprecated
    public <T extends DistributedObject> T getDistributedObject(String serviceName, Object id) {
        if (id instanceof String) {
            return (T)this.proxyManager.getOrCreateProxy(serviceName, (String)id);
        }
        throw new IllegalArgumentException("'id' must be type of String!");
    }

    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return (T)this.proxyManager.getOrCreateProxy(serviceName, name);
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public ClientConfig getClientConfig() {
        return this.config;
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientClusterService getClientClusterService() {
        return this.clusterService;
    }

    public ClientExecutionService getClientExecutionService() {
        return this.executionService;
    }

    public ClientPartitionService getClientPartitionService() {
        return this.partitionService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ClientListenerService getListenerService() {
        return this.listenerService;
    }

    public NearCacheManager getNearCacheManager() {
        return this.nearCacheManager;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public ClientExtension getClientExtension() {
        return this.clientExtension;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public short getProtocolVersion() {
        return 1;
    }

    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    public void doShutdown() {
        this.proxyManager.destroy();
        this.executionService.shutdown();
        this.partitionService.stop();
        this.transactionManager.shutdown();
        this.connectionManager.shutdown();
        this.invocationService.shutdown();
        this.listenerService.shutdown();
        this.serializationService.destroy();
        this.nearCacheManager.destroyAllNearCaches();
    }
}

