/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.AbstractClusterWideIterator;
import com.hazelcast.cache.impl.CacheKeyIteratorResult;
import com.hazelcast.cache.impl.client.CacheIterateRequest;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.util.Iterator;
import javax.cache.Cache;

public class ClientClusterWideIterator<K, V>
extends AbstractClusterWideIterator<K, V>
implements Iterator<Cache.Entry<K, V>> {
    private ClientCacheProxy<K, V> cacheProxy;
    private ClientContext context;

    public ClientClusterWideIterator(ClientCacheProxy<K, V> cacheProxy, ClientContext context) {
        super(cacheProxy, context.getPartitionService().getPartitionCount());
        this.cacheProxy = cacheProxy;
        this.context = context;
        this.advance();
    }

    protected CacheKeyIteratorResult fetch() {
        CacheIterateRequest request = new CacheIterateRequest(this.cacheProxy.getNameWithPrefix(), this.partitionIndex, this.lastTableIndex, this.fetchSize, this.cacheProxy.cacheConfig.getInMemoryFormat());
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        try {
            ClientInvocation clientInvocation = new ClientInvocation(client, (ClientMessage)request);
            ClientInvocationFuture f = clientInvocation.invoke();
            return (CacheKeyIteratorResult)this.toObject(f.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected Data toData(Object obj) {
        return this.context.getSerializationService().toData(obj);
    }

    protected <T> T toObject(Object data) {
        return (T)this.context.getSerializationService().toObject(data);
    }
}

