/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.proxy.ClientConditionProxy;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.concurrent.lock.client.GetLockCountRequest;
import com.hazelcast.concurrent.lock.client.GetRemainingLeaseRequest;
import com.hazelcast.concurrent.lock.client.IsLockedRequest;
import com.hazelcast.concurrent.lock.client.LockRequest;
import com.hazelcast.concurrent.lock.client.UnlockRequest;
import com.hazelcast.core.ICondition;
import com.hazelcast.core.ILock;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class ClientLockProxy
extends ClientProxy
implements ILock {
    private volatile Data key;

    public ClientLockProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
    }

    @Deprecated
    public Object getKey() {
        return this.getName();
    }

    public boolean isLocked() {
        IsLockedRequest request = new IsLockedRequest(this.getKeyData());
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean isLockedByCurrentThread() {
        IsLockedRequest request = new IsLockedRequest(this.getKeyData(), ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public int getLockCount() {
        GetLockCountRequest request = new GetLockCountRequest(this.getKeyData());
        return (Integer)this.invoke((ClientRequest)request);
    }

    public long getRemainingLeaseTime() {
        GetRemainingLeaseRequest request = new GetRemainingLeaseRequest(this.getKeyData());
        return (Long)this.invoke((ClientRequest)request);
    }

    public void lock(long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkPositive((long)leaseTime, (String)"leaseTime should be positive");
        LockRequest request = new LockRequest(this.getKeyData(), ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), -1L);
        this.invoke((ClientRequest)request);
    }

    public void forceUnlock() {
        UnlockRequest request = new UnlockRequest(this.getKeyData(), ThreadUtil.getThreadId(), true);
        this.invoke((ClientRequest)request);
    }

    public ICondition newCondition(String name) {
        return new ClientConditionProxy(this, name, this.getContext());
    }

    public void lock() {
        LockRequest request = new LockRequest(this.getKeyData(), ThreadUtil.getThreadId(), -1L, -1L);
        this.invoke((ClientRequest)request);
    }

    public void lockInterruptibly() throws InterruptedException {
        LockRequest request = new LockRequest(this.getKeyData(), ThreadUtil.getThreadId(), -1L, -1L);
        this.invokeInterruptibly((ClientRequest)request, this.getKeyData());
    }

    public boolean tryLock() {
        try {
            return this.tryLock(0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryLock(timeout, unit, -1L, null);
    }

    public boolean tryLock(long timeout, TimeUnit unit, long leaseTime, TimeUnit leaseUnit) throws InterruptedException {
        long timeoutInMillis = this.getTimeInMillis(timeout, unit);
        long leaseTimeInMillis = this.getTimeInMillis(leaseTime, leaseUnit);
        LockRequest request = new LockRequest(this.getKeyData(), ThreadUtil.getThreadId(), leaseTimeInMillis, timeoutInMillis);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public void unlock() {
        UnlockRequest request = new UnlockRequest(this.getKeyData(), ThreadUtil.getThreadId());
        this.invoke((ClientRequest)request);
    }

    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    private Data getKeyData() {
        if (this.key == null) {
            this.key = this.toData(this.getName());
        }
        return this.key;
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    protected <T> T invoke(ClientRequest req) {
        return super.invoke(req, this.getKeyData());
    }

    public String toString() {
        return "ILock{name='" + this.getName() + '\'' + '}';
    }
}

