/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.cache.impl.ClientCacheDistributedObject;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientProperties;
import com.hazelcast.client.config.ClientProperty;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.AddDistributedObjectListenerRequest;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientCreateRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.RemoveDistributedObjectListenerRequest;
import com.hazelcast.client.proxy.ClientAtomicLongProxy;
import com.hazelcast.client.proxy.ClientAtomicReferenceProxy;
import com.hazelcast.client.proxy.ClientCountDownLatchProxy;
import com.hazelcast.client.proxy.ClientExecutorServiceProxy;
import com.hazelcast.client.proxy.ClientIdGeneratorProxy;
import com.hazelcast.client.proxy.ClientListProxy;
import com.hazelcast.client.proxy.ClientLockProxy;
import com.hazelcast.client.proxy.ClientMapReduceProxy;
import com.hazelcast.client.proxy.ClientMultiMapProxy;
import com.hazelcast.client.proxy.ClientQueueProxy;
import com.hazelcast.client.proxy.ClientReliableTopicProxy;
import com.hazelcast.client.proxy.ClientReplicatedMapProxy;
import com.hazelcast.client.proxy.ClientRingbufferProxy;
import com.hazelcast.client.proxy.ClientSemaphoreProxy;
import com.hazelcast.client.proxy.ClientSetProxy;
import com.hazelcast.client.proxy.ClientTopicProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ClientProxyFactory;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.listener.LazyDistributedObjectEvent;
import com.hazelcast.client.txn.proxy.xa.XAResourceProxy;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.Member;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.impl.PortableDistributedObjectEvent;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public final class ProxyManager {
    private static final Class[] CONSTRUCTOR_ARGUMENT_TYPES = new Class[]{String.class, String.class};
    private final HazelcastClientInstanceImpl client;
    private final ConcurrentMap<String, ClientProxyFactory> proxyFactories = new ConcurrentHashMap<String, ClientProxyFactory>();
    private final ConcurrentMap<ObjectNamespace, ClientProxyFuture> proxies = new ConcurrentHashMap<ObjectNamespace, ClientProxyFuture>();

    public ProxyManager(HazelcastClientInstanceImpl client) {
        this.client = client;
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            for (ListenerConfig listenerConfig : listenerConfigs) {
                if (!(listenerConfig.getImplementation() instanceof DistributedObjectListener)) continue;
                this.addDistributedObjectListener((DistributedObjectListener)listenerConfig.getImplementation());
            }
        }
    }

    public void init(ClientConfig config) {
        this.register("hz:impl:mapService", this.createServiceProxyFactory(MapService.class));
        this.register("hz:impl:cacheService", ClientCacheDistributedObject.class);
        this.register("hz:impl:queueService", ClientQueueProxy.class);
        this.register("hz:impl:multiMapService", ClientMultiMapProxy.class);
        this.register("hz:impl:listService", ClientListProxy.class);
        this.register("hz:impl:setService", ClientSetProxy.class);
        this.register("hz:impl:semaphoreService", ClientSemaphoreProxy.class);
        this.register("hz:impl:topicService", ClientTopicProxy.class);
        this.register("hz:impl:atomicLongService", ClientAtomicLongProxy.class);
        this.register("hz:impl:atomicReferenceService", ClientAtomicReferenceProxy.class);
        this.register("hz:impl:executorService", ClientExecutorServiceProxy.class);
        this.register("hz:impl:lockService", ClientLockProxy.class);
        this.register("hz:impl:countDownLatchService", ClientCountDownLatchProxy.class);
        this.register("hz:impl:mapReduceService", ClientMapReduceProxy.class);
        this.register("hz:impl:replicatedMapService", ClientReplicatedMapProxy.class);
        this.register("hz:impl:xaService", XAResourceProxy.class);
        this.register("hz:impl:reliableTopicService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                return new ClientReliableTopicProxy(id, ProxyManager.this.client);
            }
        });
        this.register("hz:impl:idGeneratorService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                IAtomicLong atomicLong = ProxyManager.this.client.getAtomicLong("hz:atomic:idGenerator:" + id);
                return new ClientIdGeneratorProxy("hz:impl:idGeneratorService", id, atomicLong);
            }
        });
        this.register("hz:impl:ringbufferService", ClientRingbufferProxy.class);
        for (ProxyFactoryConfig proxyFactoryConfig : config.getProxyFactoryConfigs()) {
            try {
                ClassLoader classLoader = config.getClassLoader();
                ClientProxyFactory clientProxyFactory = proxyFactoryConfig.getFactoryImpl();
                if (clientProxyFactory == null) {
                    String className = proxyFactoryConfig.getClassName();
                    clientProxyFactory = (ClientProxyFactory)ClassLoaderUtil.newInstance((ClassLoader)classLoader, (String)className);
                }
                this.register(proxyFactoryConfig.getService(), clientProxyFactory);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    private <T> ClientProxyFactory createServiceProxyFactory(Class<T> service) {
        ClientExtension clientExtension = this.client.getClientExtension();
        return clientExtension.createServiceProxyFactory(service);
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.client;
    }

    public void register(String serviceName, ClientProxyFactory factory) {
        if (this.proxyFactories.putIfAbsent(serviceName, factory) != null) {
            throw new IllegalArgumentException("Factory for service: " + serviceName + " is already registered!");
        }
    }

    public void register(final String serviceName, final Class<? extends ClientProxy> proxyType) {
        try {
            this.register(serviceName, new ClientProxyFactory(){

                @Override
                public ClientProxy create(String id) {
                    return (ClientProxy)ProxyManager.this.instantiateClientProxy(proxyType, serviceName, id);
                }
            });
        }
        catch (Exception e) {
            throw new HazelcastException("Could not initialize Proxy", (Throwable)e);
        }
    }

    public ClientProxy getOrCreateProxy(String service, String id) {
        DefaultObjectNamespace ns = new DefaultObjectNamespace(service, id);
        ClientProxyFuture proxyFuture = (ClientProxyFuture)this.proxies.get(ns);
        if (proxyFuture != null) {
            return proxyFuture.get();
        }
        ClientProxyFactory factory = (ClientProxyFactory)this.proxyFactories.get(service);
        if (factory == null) {
            throw new IllegalArgumentException("No factory registered for service: " + service);
        }
        ClientProxy clientProxy = factory.create(id);
        proxyFuture = new ClientProxyFuture();
        ClientProxyFuture current = this.proxies.putIfAbsent((ObjectNamespace)ns, proxyFuture);
        if (current != null) {
            return current.get();
        }
        try {
            this.initializeWithRetry(clientProxy);
        }
        catch (Throwable e) {
            this.proxies.remove(ns);
            proxyFuture.set(e);
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        proxyFuture.set(clientProxy);
        return clientProxy;
    }

    public void removeProxy(String service, String id) {
        DefaultObjectNamespace ns = new DefaultObjectNamespace(service, id);
        this.proxies.remove(ns);
    }

    private void initializeWithRetry(ClientProxy clientProxy) throws Exception {
        long retryCountLimit = this.getRetryCountLimit();
        int retryCount = 0;
        while ((long)retryCount < retryCountLimit) {
            try {
                this.initialize(clientProxy);
                return;
            }
            catch (Exception e) {
                boolean retryable = this.isRetryable(e);
                if (!retryable && e instanceof ExecutionException) {
                    retryable = this.isRetryable(e.getCause());
                }
                if (!retryable) {
                    throw e;
                }
                this.sleepForProxyInitRetry();
                ++retryCount;
            }
        }
    }

    private long getRetryCountLimit() {
        ClientProperties clientProperties = this.client.getClientProperties();
        int waitTime = clientProperties.getSeconds(ClientProperty.INVOCATION_TIMEOUT_SECONDS);
        long retryTimeoutInSeconds = waitTime > 0 ? (long)waitTime : (long)Integer.parseInt(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getDefaultValue());
        return retryTimeoutInSeconds / 1L;
    }

    private boolean isRetryable(Throwable t) {
        return t instanceof RetryableException || ClientInvocation.isRetryable(t);
    }

    private void sleepForProxyInitRetry() {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        catch (InterruptedException ignored) {
            EmptyStatement.ignore((Throwable)ignored);
        }
    }

    private void initialize(ClientProxy clientProxy) throws Exception {
        Address target = this.findNextAddressToSendCreateRequest();
        Connection connection = this.getTargetOrOwnerConnection(target);
        ClientCreateRequest request = new ClientCreateRequest(clientProxy.getName(), clientProxy.getServiceName(), target);
        ClientContext context = new ClientContext(this.client, this);
        new ClientInvocation(this.client, (ClientRequest)request, connection).invoke().get();
        clientProxy.setContext(context);
        clientProxy.onInitialize();
    }

    private Connection getTargetOrOwnerConnection(Address target) throws IOException {
        if (target == null) {
            throw new IOException("Not able to setup owner connection!");
        }
        ClientConnectionManager connectionManager = this.client.getConnectionManager();
        Connection connection = connectionManager.getConnection(target);
        if (connection == null) {
            Address ownerConnectionAddress = this.client.getClientClusterService().getOwnerConnectionAddress();
            if (ownerConnectionAddress == null) {
                throw new IOException("Not able to setup owner connection!");
            }
            connection = connectionManager.getConnection(ownerConnectionAddress);
            if (connection == null) {
                throw new IOException("Client is not connected to member " + target);
            }
        }
        return connection;
    }

    public Address findNextAddressToSendCreateRequest() {
        int clusterSize = this.client.getClientClusterService().getSize();
        Member liteMember = null;
        LoadBalancer loadBalancer = this.client.getLoadBalancer();
        for (int i = 0; i < clusterSize; ++i) {
            Member member = loadBalancer.next();
            if (member != null && !member.isLiteMember()) {
                return member.getAddress();
            }
            if (liteMember != null) continue;
            liteMember = member;
        }
        return liteMember != null ? liteMember.getAddress() : null;
    }

    public Collection<? extends DistributedObject> getDistributedObjects() {
        LinkedList<ClientProxy> objects = new LinkedList<ClientProxy>();
        for (ClientProxyFuture future : this.proxies.values()) {
            objects.add(future.get());
        }
        return objects;
    }

    public void destroy() {
        for (ClientProxyFuture future : this.proxies.values()) {
            future.get().onShutdown();
        }
        this.proxies.clear();
    }

    public String addDistributedObjectListener(DistributedObjectListener listener) {
        AddDistributedObjectListenerRequest addRequest = new AddDistributedObjectListenerRequest();
        DistributedObjectEventHandler eventHandler = new DistributedObjectEventHandler(listener, this);
        RemoveDistributedObjectListenerRequest removeRequest = new RemoveDistributedObjectListenerRequest();
        return this.client.getListenerService().registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, eventHandler);
    }

    public boolean removeDistributedObjectListener(String id) {
        return this.client.getListenerService().deregisterListener(id);
    }

    private <T> T instantiateClientProxy(Class<T> proxyType, String serviceName, String id) {
        try {
            Constructor<T> constructor = proxyType.getConstructor(CONSTRUCTOR_ARGUMENT_TYPES);
            return constructor.newInstance(serviceName, id);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private static class ClientProxyFuture {
        volatile Object proxy;

        private ClientProxyFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClientProxy get() {
            if (this.proxy == null) {
                boolean interrupted = false;
                ClientProxyFuture clientProxyFuture = this;
                synchronized (clientProxyFuture) {
                    while (this.proxy == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.proxy instanceof Throwable) {
                throw ExceptionUtil.rethrow((Throwable)((Throwable)this.proxy));
            }
            return (ClientProxy)this.proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(Object o) {
            if (o == null) {
                throw new IllegalArgumentException();
            }
            ClientProxyFuture clientProxyFuture = this;
            synchronized (clientProxyFuture) {
                this.proxy = o;
                this.notifyAll();
            }
        }
    }

    private final class DistributedObjectEventHandler
    implements EventHandler<PortableDistributedObjectEvent> {
        private final DistributedObjectListener listener;
        private ProxyManager proxyManager;

        private DistributedObjectEventHandler(DistributedObjectListener listener, ProxyManager proxyManager2) {
            this.listener = listener;
            this.proxyManager = proxyManager2;
        }

        @Override
        public void handle(PortableDistributedObjectEvent e) {
            String name = e.getName();
            String serviceName = e.getServiceName();
            DistributedObjectEvent.EventType eventType = e.getEventType();
            DefaultObjectNamespace ns = new DefaultObjectNamespace(serviceName, name);
            ClientProxyFuture future = (ClientProxyFuture)ProxyManager.this.proxies.get(ns);
            ClientProxy proxy = future == null ? null : future.get();
            LazyDistributedObjectEvent event = new LazyDistributedObjectEvent(eventType, serviceName, name, proxy, this.proxyManager);
            if (DistributedObjectEvent.EventType.CREATED.equals((Object)eventType)) {
                this.listener.distributedObjectCreated((DistributedObjectEvent)event);
            } else if (DistributedObjectEvent.EventType.DESTROYED.equals((Object)eventType)) {
                this.listener.distributedObjectDestroyed((DistributedObjectEvent)event);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

