/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.map.impl.nearcache.ClientHeapNearCache;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.client.MapAddNearCacheEntryListenerRequest;
import com.hazelcast.map.impl.client.MapRemoveEntryListenerRequest;
import com.hazelcast.map.impl.nearcache.BatchNearCacheInvalidation;
import com.hazelcast.map.impl.nearcache.CleaningNearCacheInvalidation;
import com.hazelcast.map.impl.nearcache.SingleNearCacheInvalidation;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class NearCachedClientMapProxy<K, V>
extends ClientMapProxy<K, V> {
    protected NearCache<Data, Object> nearCache;
    protected volatile String invalidationListenerId;

    public NearCachedClientMapProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.init();
    }

    protected void init() {
        ClientConfig clientConfig = this.getContext().getClientConfig();
        NearCacheConfig nearCacheConfig = clientConfig.getNearCacheConfig(this.name);
        this.nearCache = new ClientHeapNearCache<Data>(this.name, this.getContext(), nearCacheConfig);
        if (this.nearCache.isInvalidateOnChange()) {
            this.addNearCacheInvalidateListener();
        }
    }

    @Override
    protected boolean containsKeyInternal(Data keyData) {
        Object cached = this.nearCache.get((Object)keyData);
        if (cached != null) {
            return NearCache.NULL_OBJECT != cached;
        }
        return super.containsKeyInternal(keyData);
    }

    @Override
    protected V getInternal(Data keyData) {
        Object cached = this.nearCache.get((Object)keyData);
        if (cached != null) {
            if (NearCache.NULL_OBJECT == cached) {
                return null;
            }
            return (V)cached;
        }
        Object response = super.getInternal(keyData);
        this.nearCache.put((Object)keyData, response);
        return response;
    }

    @Override
    protected V removeInternal(Data keyData) {
        this.invalidateNearCache(keyData);
        return super.removeInternal(keyData);
    }

    @Override
    protected boolean removeInternal(Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        return super.removeInternal(keyData, valueData);
    }

    @Override
    protected void deleteInternal(Data keyData) {
        this.invalidateNearCache(keyData);
        super.deleteInternal(keyData);
    }

    @Override
    public ICompletableFuture<V> getAsyncInternal(final Data keyData) {
        Object cached = this.nearCache.get((Object)keyData);
        if (cached != null && NearCache.NULL_OBJECT != cached) {
            return new CompletedFuture(this.getContext().getSerializationService(), cached, this.getContext().getExecutionService().getAsyncExecutor());
        }
        ICompletableFuture future = super.getAsyncInternal(keyData);
        future.andThen(new ExecutionCallback<V>(){

            public void onResponse(V response) {
                NearCachedClientMapProxy.this.nearCache.put((Object)keyData, response);
            }

            public void onFailure(Throwable t) {
            }
        });
        return future;
    }

    @Override
    protected Future<V> putAsyncInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        return super.putAsyncInternal(ttl, timeunit, keyData, valueData);
    }

    @Override
    protected Future<V> removeAsyncInternal(Data keyData) {
        this.invalidateNearCache(keyData);
        return super.removeAsyncInternal(keyData);
    }

    @Override
    protected Boolean tryRemoveInternal(long timeout, TimeUnit timeunit, Data keyData) {
        this.invalidateNearCache(keyData);
        return super.tryRemoveInternal(timeout, timeunit, keyData);
    }

    @Override
    protected Boolean tryPutInternal(long timeout, TimeUnit timeunit, Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        return super.tryPutInternal(timeout, timeunit, keyData, valueData);
    }

    @Override
    protected V putInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        return super.putInternal(ttl, timeunit, keyData, valueData);
    }

    @Override
    protected void putTransientInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        super.putTransientInternal(ttl, timeunit, keyData, valueData);
    }

    @Override
    protected V putIfAbsentInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        return super.putIfAbsentInternal(ttl, timeunit, keyData, valueData);
    }

    @Override
    protected Boolean replaceIfSameInternal(Data keyData, Data oldValueData, Data newValueData) {
        this.invalidateNearCache(keyData);
        return super.replaceIfSameInternal(keyData, oldValueData, newValueData);
    }

    @Override
    protected V replaceInternal(Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        return super.replaceInternal(keyData, valueData);
    }

    @Override
    protected void setInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        super.setInternal(ttl, timeunit, keyData, valueData);
    }

    @Override
    protected Boolean evictInternal(Data keyData) {
        this.invalidateNearCache(keyData);
        return super.evictInternal(keyData);
    }

    @Override
    public void evictAll() {
        this.nearCache.clear();
        super.evictAll();
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        if (replaceExistingValues) {
            this.nearCache.clear();
        }
        super.loadAll(replaceExistingValues);
    }

    @Override
    protected void loadAllInternal(boolean replaceExistingValues, List<Data> dataKeys) {
        this.invalidateNearCache(dataKeys);
        super.loadAllInternal(replaceExistingValues, dataKeys);
    }

    @Override
    protected List<MapEntries> getAllInternal(Map<Integer, List<Data>> partitionToKeyData, Map<K, V> result) {
        for (Map.Entry<Integer, List<Data>> partitionKeyEntry : partitionToKeyData.entrySet()) {
            List<Data> keyList = partitionKeyEntry.getValue();
            Iterator<Data> iterator = keyList.iterator();
            while (iterator.hasNext()) {
                Data key = iterator.next();
                Object cached = this.nearCache.get((Object)key);
                if (cached == null || NearCache.NULL_OBJECT == cached) continue;
                result.put(this.toObject(key), cached);
                iterator.remove();
            }
        }
        List<MapEntries> responses = super.getAllInternal(partitionToKeyData, result);
        for (MapEntries entries : responses) {
            for (Map.Entry entry : entries.entries()) {
                this.nearCache.put(entry.getKey(), entry.getValue());
            }
        }
        return responses;
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        LocalMapStats localMapStats = super.getLocalMapStats();
        NearCacheStats nearCacheStats = this.nearCache.getNearCacheStats();
        ((LocalMapStatsImpl)localMapStats).setNearCacheStats((NearCacheStats)((NearCacheStatsImpl)nearCacheStats));
        return localMapStats;
    }

    @Override
    public Object executeOnKeyInternal(Data keyData, EntryProcessor entryProcessor) {
        this.invalidateNearCache(keyData);
        return super.executeOnKeyInternal(keyData, entryProcessor);
    }

    @Override
    public Future submitToKeyInternal(Data keyData, EntryProcessor entryProcessor) {
        this.invalidateNearCache(keyData);
        return super.submitToKeyInternal(keyData, entryProcessor);
    }

    @Override
    public void submitToKeyInternal(Data keyData, EntryProcessor entryProcessor, ExecutionCallback callback) {
        this.invalidateNearCache(keyData);
        super.submitToKeyInternal(keyData, entryProcessor, callback);
    }

    @Override
    protected Map<K, Object> prepareResult(MapEntries mapEntries) {
        if (mapEntries.isEmpty()) {
            return Collections.emptyMap();
        }
        Map result = MapUtil.createHashMap((int)mapEntries.size());
        for (Map.Entry dataEntry : mapEntries) {
            Data keyData = (Data)dataEntry.getKey();
            this.invalidateNearCache(keyData);
            Data valueData = (Data)dataEntry.getValue();
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    @Override
    protected void putAllInternal(List<Future<?>> futures, MapEntries[] entriesPerPartition) {
        for (int i = 0; i < entriesPerPartition.length; ++i) {
            MapEntries mapEntries = entriesPerPartition[i];
            if (mapEntries == null) continue;
            Collection entries = mapEntries.entries();
            for (Map.Entry entry : entries) {
                Data keyData = (Data)entry.getKey();
                this.invalidateNearCache(keyData);
            }
        }
        super.putAllInternal(futures, entriesPerPartition);
    }

    @Override
    public void clear() {
        this.nearCache.clear();
        super.clear();
    }

    @Override
    protected void onDestroy() {
        this.removeNearCacheInvalidationListener();
        this.nearCache.destroy();
        super.onDestroy();
    }

    @Override
    protected void onShutdown() {
        this.removeNearCacheInvalidationListener();
        this.nearCache.destroy();
        super.onShutdown();
    }

    public NearCache<Data, Object> getNearCache() {
        return this.nearCache;
    }

    protected void invalidateNearCache(Data key) {
        this.nearCache.remove((Object)key);
    }

    protected void invalidateNearCache(Collection<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (Data key : keys) {
            this.nearCache.remove((Object)key);
        }
    }

    protected void addNearCacheInvalidateListener() {
        InvalidationListener handler = new InvalidationListener();
        this.addNearCacheInvalidateListener(handler);
    }

    public void addNearCacheInvalidateListener(EventHandler handler) {
        try {
            MapAddNearCacheEntryListenerRequest addRequest = new MapAddNearCacheEntryListenerRequest(this.name, false);
            MapRemoveEntryListenerRequest removeRequest = new MapRemoveEntryListenerRequest(this.name);
            this.invalidationListenerId = this.registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, handler);
        }
        catch (Exception e) {
            Logger.getLogger(ClientHeapNearCache.class).severe("-----------------\n Near Cache is not initialized!!! \n-----------------", (Throwable)e);
        }
    }

    protected void removeNearCacheInvalidationListener() {
        String invalidationListenerId = this.invalidationListenerId;
        if (invalidationListenerId == null) {
            return;
        }
        this.deregisterListener(invalidationListenerId);
    }

    protected final class InvalidationListener
    implements EventHandler<Object> {
        @Override
        public void handle(Object event) {
            if (event instanceof BatchNearCacheInvalidation) {
                List invalidations = ((BatchNearCacheInvalidation)event).getInvalidations();
                for (SingleNearCacheInvalidation invalidation : invalidations) {
                    NearCachedClientMapProxy.this.nearCache.remove((Object)invalidation.getKey());
                }
                return;
            }
            if (event instanceof SingleNearCacheInvalidation) {
                Data key = ((SingleNearCacheInvalidation)event).getKey();
                NearCachedClientMapProxy.this.nearCache.remove((Object)key);
                return;
            }
            if (event instanceof CleaningNearCacheInvalidation) {
                NearCachedClientMapProxy.this.nearCache.clear();
                return;
            }
            throw new IllegalArgumentException("Unexpected event received [" + event + ']');
        }

        @Override
        public void beforeListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
        }

        @Override
        public void onListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
        }
    }
}

