/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.AbstractClientSelectionHandler;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.hazelcast.util.Clock;
import java.io.EOFException;
import java.nio.ByteBuffer;

public class ClientReadHandler
extends AbstractClientSelectionHandler {
    private final ByteBuffer buffer;
    private volatile long lastHandle;
    private Packet packet;

    public ClientReadHandler(ClientConnection connection, NonBlockingIOThread ioThread, int bufferSize) {
        super(connection, ioThread);
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.lastHandle = Clock.currentTimeMillis();
    }

    @Override
    public void run() {
        this.registerOp(1);
    }

    public void handle() throws Exception {
        this.lastHandle = Clock.currentTimeMillis();
        if (!this.connection.isAlive()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("We are being asked to read, but connection is not live so we won't");
            }
            return;
        }
        int readBytes = this.socketChannel.read(this.buffer);
        if (readBytes <= 0) {
            if (readBytes == -1) {
                throw new EOFException("Remote socket closed!");
            }
            return;
        }
        this.buffer.flip();
        this.readPacket();
        if (this.buffer.hasRemaining()) {
            this.buffer.compact();
        } else {
            this.buffer.clear();
        }
    }

    private void readPacket() {
        while (this.buffer.hasRemaining()) {
            boolean complete;
            if (this.packet == null) {
                this.packet = new Packet();
            }
            if (!(complete = this.packet.readFrom(this.buffer))) break;
            this.packet.setConn((Connection)this.connection);
            this.connectionManager.handlePacket(this.packet);
            this.packet = null;
        }
    }

    long getLastHandle() {
        return this.lastHandle;
    }
}

