/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.buildutils;

import aQute.lib.osgi.Instruction;
import com.hazelcast.buildutils.ElementParser;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class HazelcastManifestTransformer
extends ManifestResourceTransformer {
    private static final ILogger LOGGER = Logger.getLogger(HazelcastManifestTransformer.class);
    private static final String VERSION_PREFIX = "version=";
    private static final String RESOLUTION_PREFIX = "resolution:=";
    private static final String USES_PREFIX = "uses:=";
    private static final int VERSION_OFFSET = 8;
    private static final int USES_OFFSET = 7;
    private static final String IMPORT_PACKAGE = "Import-Package";
    private static final String EXPORT_PACKAGE = "Export-Package";
    private static final Attributes.Name AUTOMATIC_MODULE_NAME = new Attributes.Name("Automatic-Module-Name");
    private String mainClass;
    private Map<String, Object> manifestEntries;
    private Map<String, String> overrideInstructions;
    private final Map<String, PackageDefinition> importedPackages = new HashMap<String, PackageDefinition>();
    private final Map<String, PackageDefinition> exportedPackages = new HashMap<String, PackageDefinition>();
    private final List<InstructionDefinition> importOverrideInstructions = new ArrayList<InstructionDefinition>();
    private final List<InstructionDefinition> exportOverrideInstructions = new ArrayList<InstructionDefinition>();
    private Manifest shadedManifest;

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
        super.setMainClass(mainClass);
    }

    public void setManifestEntries(Map<String, Object> manifestEntries) {
        this.manifestEntries = manifestEntries;
        super.setManifestEntries(manifestEntries);
    }

    public void setOverrideInstructions(Map<String, String> overrideInstructions) {
        this.overrideInstructions = overrideInstructions;
    }

    public boolean canTransformResource(String resource) {
        return "META-INF/MANIFEST.MF".equals(resource.toUpperCase(Locale.ROOT));
    }

    public void processResource(String resource, InputStream inputStream, List<Relocator> relocators, long time) throws IOException {
        String exportPackages;
        Attributes attributes;
        if (this.shadedManifest == null) {
            this.shadedManifest = new Manifest(inputStream);
            attributes = this.shadedManifest.getMainAttributes();
        } else {
            Manifest manifest = new Manifest(inputStream);
            attributes = manifest.getMainAttributes();
        }
        String importPackages = attributes.getValue(IMPORT_PACKAGE);
        if (importPackages != null) {
            List<String> definitions = ElementParser.parseDelimitedString(importPackages, ',', true);
            for (String definition : definitions) {
                PackageDefinition packageDefinition = new PackageDefinition(definition);
                String packageName = packageDefinition.packageName;
                PackageDefinition oldPackageDefinition = this.importedPackages.get(packageName);
                this.importedPackages.put(packageName, this.findStrongerDefinition(packageDefinition, oldPackageDefinition));
            }
        }
        if ((exportPackages = attributes.getValue(EXPORT_PACKAGE)) != null) {
            List<String> definitions = ElementParser.parseDelimitedString(exportPackages, ',', true);
            for (String definition : definitions) {
                PackageDefinition packageDefinition = new PackageDefinition(definition);
                String packageName = packageDefinition.packageName;
                PackageDefinition oldPackageDefinition = this.exportedPackages.get(packageName);
                this.exportedPackages.put(packageName, this.mergeExportUsesConstraint(packageDefinition, oldPackageDefinition));
            }
        }
        IOUtil.close((InputStream)inputStream);
    }

    private PackageDefinition findStrongerDefinition(PackageDefinition packageDefinition, PackageDefinition oldPackageDefinition) {
        if (packageDefinition.removeImport) {
            return packageDefinition;
        }
        if (oldPackageDefinition == null || oldPackageDefinition.resolutionOptional && !packageDefinition.resolutionOptional) {
            return packageDefinition;
        }
        if (!oldPackageDefinition.resolutionOptional && packageDefinition.resolutionOptional) {
            return oldPackageDefinition;
        }
        if (oldPackageDefinition.version == null && packageDefinition.version != null) {
            return packageDefinition;
        }
        if (oldPackageDefinition.version != null && packageDefinition.version == null) {
            return oldPackageDefinition;
        }
        return oldPackageDefinition;
    }

    private PackageDefinition mergeExportUsesConstraint(PackageDefinition packageDefinition, PackageDefinition oldPackageDefinition) {
        LinkedHashSet<String> uses = new LinkedHashSet<String>();
        if (oldPackageDefinition != null) {
            uses.addAll(oldPackageDefinition.uses);
        }
        uses.addAll(packageDefinition.uses);
        String packageName = packageDefinition.packageName;
        boolean resolutionOptional = packageDefinition.resolutionOptional;
        String version = packageDefinition.version;
        return new PackageDefinition(packageName, resolutionOptional, version, uses);
    }

    public boolean hasTransformedResource() {
        return true;
    }

    public void modifyOutputStream(JarOutputStream jarOutputStream) throws IOException {
        if (this.shadedManifest == null) {
            this.shadedManifest = new Manifest();
        }
        Attributes attributes = this.shadedManifest.getMainAttributes();
        if (this.overrideInstructions != null) {
            this.precompileOverrideInstructions();
            attributes.putValue(IMPORT_PACKAGE, StringUtils.join(this.shadeImports().iterator(), (String)","));
            attributes.putValue(EXPORT_PACKAGE, StringUtils.join(this.shadeExports().iterator(), (String)","));
        }
        attributes.putValue("Created-By", "HazelcastManifestTransformer through Shade Plugin");
        if (this.mainClass != null) {
            attributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        if (this.manifestEntries != null) {
            for (Map.Entry<String, Object> entry : this.manifestEntries.entrySet()) {
                attributes.put(new Attributes.Name(entry.getKey()), entry.getValue());
            }
        }
        attributes.remove(AUTOMATIC_MODULE_NAME);
        jarOutputStream.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        this.shadedManifest.write(jarOutputStream);
        jarOutputStream.flush();
    }

    private void precompileOverrideInstructions() {
        String exportPackageInstructions;
        String importPackageInstructions = this.overrideInstructions.get(IMPORT_PACKAGE);
        if (importPackageInstructions != null) {
            List<String> packageInstructions = ElementParser.parseDelimitedString(importPackageInstructions, ',', true);
            for (String packageInstruction : packageInstructions) {
                PackageDefinition packageDefinition = new PackageDefinition(packageInstruction);
                Instruction instruction = Instruction.getPattern((String)packageDefinition.packageName);
                LOGGER.fine("Compiled import instruction '%s' -> %s", (Object)packageInstruction, (Object)instruction);
                this.importOverrideInstructions.add(new InstructionDefinition(packageDefinition, instruction));
            }
        }
        if ((exportPackageInstructions = this.overrideInstructions.get(EXPORT_PACKAGE)) != null) {
            List<String> packageInstructions = ElementParser.parseDelimitedString(exportPackageInstructions, ',', true);
            for (String packageInstruction : packageInstructions) {
                PackageDefinition packageDefinition = new PackageDefinition(packageInstruction);
                Instruction instruction = Instruction.getPattern((String)packageDefinition.packageName);
                LOGGER.fine("Compiled export instruction '%s' -> %s", (Object)packageInstruction, (Object)instruction);
                this.exportOverrideInstructions.add(new InstructionDefinition(packageDefinition, instruction));
            }
        }
    }

    private Set<String> shadeExports() {
        LinkedHashSet<String> exports = new LinkedHashSet<String>();
        for (Map.Entry<String, PackageDefinition> entry : this.exportedPackages.entrySet()) {
            String definition = entry.getValue().buildDefinition(false);
            exports.add(definition);
            LOGGER.fine("Adding shaded export -> %s", (Object)definition);
        }
        return exports;
    }

    private Set<String> shadeImports() {
        for (String export : this.exportedPackages.keySet()) {
            PackageDefinition definition = new PackageDefinition(export);
            this.importedPackages.remove(definition.packageName);
        }
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        for (Map.Entry<String, PackageDefinition> entry : this.importedPackages.entrySet()) {
            PackageDefinition original = entry.getValue();
            PackageDefinition overridden = this.overridePackageDefinitionResolution(original);
            if (overridden != null) {
                String definition = overridden.buildDefinition(true);
                imports.add(definition);
                LOGGER.fine("Adding shaded import -> %s", (Object)definition);
                continue;
            }
            LOGGER.fine("Removing shaded import -> %s", (Object)entry.getValue().packageName);
        }
        return imports;
    }

    private PackageDefinition overridePackageDefinitionResolution(PackageDefinition packageDefinition) {
        for (InstructionDefinition instructionDefinition : this.importOverrideInstructions) {
            Instruction instruction = instructionDefinition.instruction;
            if (!instruction.matches(packageDefinition.packageName)) continue;
            if (instruction.isNegated()) {
                LOGGER.fine("Instruction '%s' -> package '%s'", (Object)instruction, (Object)packageDefinition.packageName);
                return null;
            }
            LOGGER.fine("Instruction '%s' -> package '%s'", (Object)instruction, (Object)packageDefinition.packageName);
            PackageDefinition override = instructionDefinition.packageDefinition;
            String packageName = packageDefinition.packageName;
            String version = packageDefinition.version;
            Set<String> uses = packageDefinition.uses;
            return new PackageDefinition(packageName, override.resolutionOptional, version, uses);
        }
        return packageDefinition;
    }

    static final class PackageDefinition {
        private final boolean removeImport;
        private final String packageName;
        private final boolean resolutionOptional;
        private final String version;
        private final Set<String> uses;

        PackageDefinition(String definition) {
            String[] tokens = definition.split(";");
            this.removeImport = tokens[0].startsWith("!");
            this.packageName = tokens[0];
            this.resolutionOptional = this.findResolutionConstraint(tokens);
            this.version = this.findVersionConstraint(tokens);
            this.uses = this.findUsesConstraint(tokens);
        }

        PackageDefinition(String packageName, boolean resolutionOptional, String version, Set<String> uses) {
            this.removeImport = packageName.startsWith("!");
            this.packageName = packageName;
            this.resolutionOptional = resolutionOptional;
            this.version = version;
            this.uses = new LinkedHashSet<String>(uses);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackageDefinition that = (PackageDefinition)o;
            return Objects.equals(this.packageName, that.packageName);
        }

        public int hashCode() {
            return this.packageName != null ? this.packageName.hashCode() : 0;
        }

        public String toString() {
            return "PackageDefinition{packageName='" + this.packageName + "', resolutionOptional=" + this.resolutionOptional + ", version='" + this.version + "', uses=" + String.valueOf(this.uses) + "}";
        }

        String buildDefinition(boolean addResolutionConstraint) {
            StringBuilder sb = new StringBuilder(this.packageName);
            if (addResolutionConstraint && this.resolutionOptional) {
                sb.append(";").append(HazelcastManifestTransformer.RESOLUTION_PREFIX).append("optional");
            }
            if (this.version != null) {
                sb.append(";").append(HazelcastManifestTransformer.VERSION_PREFIX).append(this.version);
            }
            if (this.uses != null && !this.uses.isEmpty()) {
                sb.append(";").append(HazelcastManifestTransformer.USES_PREFIX).append('\"').append(StringUtils.join(this.uses.iterator(), (String)",")).append('\"');
            }
            return sb.toString();
        }

        private String findVersionConstraint(String[] tokens) {
            for (String token : tokens) {
                if (!token.startsWith(HazelcastManifestTransformer.VERSION_PREFIX)) continue;
                return token.substring(8);
            }
            return null;
        }

        private boolean findResolutionConstraint(String[] tokens) {
            for (String token : tokens) {
                if (!token.startsWith(HazelcastManifestTransformer.RESOLUTION_PREFIX)) continue;
                return token.toLowerCase(Locale.ROOT).equals("resolution:=optional");
            }
            return false;
        }

        private Set<String> findUsesConstraint(String[] tokens) {
            for (String token : tokens) {
                if (!token.startsWith(HazelcastManifestTransformer.USES_PREFIX)) continue;
                String packages = token.substring(7, token.length() - 1);
                String[] sepPackages = packages.split(",");
                return new LinkedHashSet<String>(Arrays.asList(sepPackages));
            }
            return Collections.emptySet();
        }
    }

    static final class InstructionDefinition {
        private final PackageDefinition packageDefinition;
        private final Instruction instruction;

        InstructionDefinition(PackageDefinition packageDefinition, Instruction instruction) {
            this.packageDefinition = packageDefinition;
            this.instruction = instruction;
        }

        public String toString() {
            return "InstructionDefinition{packageDefinition=" + String.valueOf(this.packageDefinition) + ", instruction=" + String.valueOf(this.instruction) + "}";
        }
    }
}

