/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.buildutils;

import com.hazelcast.internal.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ReproducibleResourceTransformer;

public class HazelcastLicenseResourceTransformer
implements ReproducibleResourceTransformer {
    private static final String LICENSE_PATH = "META-INF/LICENSE";
    private static final String LICENSE_TXT_PATH = "META-INF/LICENSE.txt";
    private long time = Long.MIN_VALUE;

    public boolean canTransformResource(String resource) {
        return StringUtil.equalsIgnoreCase((String)resource, (String)LICENSE_PATH) || StringUtil.equalsIgnoreCase((String)resource, (String)LICENSE_TXT_PATH);
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) {
        if (time > this.time) {
            this.time = time;
        }
    }

    public boolean hasTransformedResource() {
        return true;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        JarEntry jarEntry = new JarEntry(LICENSE_PATH);
        jarEntry.setTime(this.time);
        jos.putNextEntry(jarEntry);
        jos.write(LicenseHolder.LICENSE);
        jos.closeEntry();
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators) {
        this.processResource(resource, is, relocators, 0L);
    }

    static class LicenseHolder {
        public static final byte[] LICENSE;

        LicenseHolder() {
        }

        static {
            byte[] loaded = null;
            try (InputStream input = LicenseHolder.class.getResourceAsStream("/LICENSE");
                 ByteArrayOutputStream output = new ByteArrayOutputStream();){
                int n;
                byte[] buffer = new byte[1024];
                while (-1 != (n = input.read(buffer))) {
                    output.write(buffer, 0, n);
                }
                loaded = output.toByteArray();
            }
            catch (IOException e) {
                new RuntimeException("Unable to load the LICENSE file", e);
            }
            LICENSE = loaded;
        }
    }
}

