/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.buildutils;

import aQute.lib.osgi.Instruction;
import com.hazelcast.buildutils.ElementParser;
import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.Collections;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class HazelcastManifestTransformer
extends ManifestResourceTransformer {
    private static final String VERSION_PREFIX = "version=";
    private static final String RESOLUTION_PREFIX = "resolution:=";
    private static final String USES_PREFIX = "uses:=";
    private static final int VERSION_OFFSET = 8;
    private static final int USES_OFFSET = 7;
    private static final String IMPORT_PACKAGE = "Import-Package";
    private static final String EXPORT_PACKAGE = "Export-Package";
    private final Map<String, PackageDefinition> importedPackages = new HashMap<String, PackageDefinition>();
    private final Map<String, PackageDefinition> exportedPackages = new HashMap<String, PackageDefinition>();
    private final List<InstructionDefinition> importOverrideInstructions = new ArrayList<InstructionDefinition>();
    private final List<InstructionDefinition> exportOverrideInstructions = new ArrayList<InstructionDefinition>();
    private Manifest shadedManifest;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Filled by Maven")
    private Map<String, Attributes> manifestEntries;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Filled by Maven")
    private String mainClass;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Filled by Maven")
    private Map<String, String> overrideInstructions;

    public boolean canTransformResource(String resource) {
        return "META-INF/MANIFEST.MF".equalsIgnoreCase(resource);
    }

    public void processResource(String resource, InputStream inputStream, List<Relocator> relocators) throws IOException {
        String exportPackages;
        Attributes attributes;
        if (this.shadedManifest == null) {
            this.shadedManifest = new Manifest(inputStream);
            attributes = this.shadedManifest.getMainAttributes();
        } else {
            Manifest manifest = new Manifest(inputStream);
            attributes = manifest.getMainAttributes();
        }
        String importPackages = attributes.getValue(IMPORT_PACKAGE);
        if (importPackages != null) {
            List<String> definitions = ElementParser.parseDelimitedString(importPackages, ',', true);
            for (String definition : definitions) {
                PackageDefinition packageDefinition = new PackageDefinition(definition);
                String packageName = packageDefinition.packageName;
                PackageDefinition oldPackageDefinition = this.importedPackages.get(packageName);
                this.importedPackages.put(packageName, this.findStrongerDefinition(packageDefinition, oldPackageDefinition));
            }
        }
        if ((exportPackages = attributes.getValue(EXPORT_PACKAGE)) != null) {
            List<String> definitions = ElementParser.parseDelimitedString(exportPackages, ',', true);
            for (String definition : definitions) {
                PackageDefinition packageDefinition = new PackageDefinition(definition);
                String packageName = packageDefinition.packageName;
                PackageDefinition oldPackageDefinition = this.exportedPackages.get(packageName);
                this.exportedPackages.put(packageName, this.mergeExportUsesConstraint(packageDefinition, oldPackageDefinition));
            }
        }
        IOUtil.close((InputStream)inputStream);
    }

    private PackageDefinition findStrongerDefinition(PackageDefinition packageDefinition, PackageDefinition oldPackageDefinition) {
        if (oldPackageDefinition == null || oldPackageDefinition.resolutionOptional && !packageDefinition.resolutionOptional) {
            return packageDefinition;
        }
        if (!oldPackageDefinition.resolutionOptional && packageDefinition.resolutionOptional) {
            return oldPackageDefinition;
        }
        if (oldPackageDefinition.version == null && packageDefinition.version != null) {
            return packageDefinition;
        }
        if (oldPackageDefinition.version != null && packageDefinition.version == null) {
            return oldPackageDefinition;
        }
        return oldPackageDefinition;
    }

    private PackageDefinition mergeExportUsesConstraint(PackageDefinition packageDefinition, PackageDefinition oldPackageDefinition) {
        LinkedHashSet uses = new LinkedHashSet();
        if (oldPackageDefinition != null) {
            uses.addAll(oldPackageDefinition.uses);
        }
        uses.addAll(packageDefinition.uses);
        String packageName = packageDefinition.packageName;
        boolean resolutionOptional = packageDefinition.resolutionOptional;
        String version = packageDefinition.version;
        return new PackageDefinition(packageName, resolutionOptional, version, uses);
    }

    public boolean hasTransformedResource() {
        return true;
    }

    public void modifyOutputStream(JarOutputStream jarOutputStream) throws IOException {
        if (this.shadedManifest == null) {
            this.shadedManifest = new Manifest();
        }
        this.precompileOverrideInstructions();
        Attributes attributes = this.shadedManifest.getMainAttributes();
        attributes.putValue(IMPORT_PACKAGE, StringUtils.join(this.shadeImports().iterator(), (String)","));
        attributes.putValue(EXPORT_PACKAGE, StringUtils.join(this.shadeExports().iterator(), (String)","));
        attributes.putValue("Created-By", "HazelcastManifestTransformer through Shade Plugin");
        if (this.mainClass != null) {
            attributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        if (this.manifestEntries != null) {
            for (Map.Entry<String, Attributes> entry : this.manifestEntries.entrySet()) {
                attributes.put(new Attributes.Name(entry.getKey()), entry.getValue());
            }
        }
        jarOutputStream.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        this.shadedManifest.write(jarOutputStream);
        jarOutputStream.flush();
    }

    @SuppressWarnings(value={"NP_UNWRITTEN_FIELD"}, justification="Field is set by Maven")
    private void precompileOverrideInstructions() {
        String exportPackageInstructions;
        String importPackageInstructions = this.overrideInstructions.get(IMPORT_PACKAGE);
        if (importPackageInstructions != null) {
            List<String> packageInstructions = ElementParser.parseDelimitedString(importPackageInstructions, ',', true);
            for (String packageInstruction : packageInstructions) {
                PackageDefinition packageDefinition = new PackageDefinition(packageInstruction);
                Instruction instruction = Instruction.getPattern((String)packageDefinition.packageName);
                System.out.println("Compiled import instruction '" + packageInstruction + "' -> " + instruction);
                this.importOverrideInstructions.add(new InstructionDefinition(packageDefinition, instruction));
            }
        }
        if ((exportPackageInstructions = this.overrideInstructions.get(EXPORT_PACKAGE)) != null) {
            List<String> packageInstructions = ElementParser.parseDelimitedString(exportPackageInstructions, ',', true);
            for (String packageInstruction : packageInstructions) {
                PackageDefinition packageDefinition = new PackageDefinition(packageInstruction);
                Instruction instruction = Instruction.getPattern((String)packageDefinition.packageName);
                System.out.println("Compiled export instruction '" + packageInstruction + "' -> " + instruction);
                this.exportOverrideInstructions.add(new InstructionDefinition(packageDefinition, instruction));
            }
        }
    }

    private Set<String> shadeExports() {
        LinkedHashSet<String> exports = new LinkedHashSet<String>();
        for (Map.Entry<String, PackageDefinition> entry : this.exportedPackages.entrySet()) {
            String definition = entry.getValue().buildDefinition(false);
            exports.add(definition);
            System.out.println("Adding shaded export -> " + definition);
        }
        return exports;
    }

    private Set<String> shadeImports() {
        for (String export : this.exportedPackages.keySet()) {
            PackageDefinition definition = new PackageDefinition(export);
            this.importedPackages.remove(definition.packageName);
        }
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        for (Map.Entry<String, PackageDefinition> entry : this.importedPackages.entrySet()) {
            PackageDefinition original = entry.getValue();
            PackageDefinition overridden = this.overridePackageDefinitionResolution(original);
            String definition = overridden.buildDefinition(true);
            imports.add(definition);
            System.out.println("Adding shaded import -> " + definition);
        }
        return imports;
    }

    private PackageDefinition overridePackageDefinitionResolution(PackageDefinition packageDefinition) {
        for (InstructionDefinition instructionDefinition : this.importOverrideInstructions) {
            Instruction instruction = instructionDefinition.instruction;
            boolean instructed = !instruction.isNegated() == instruction.matches(packageDefinition.packageName);
            if (!instructed) continue;
            System.out.println("Instruction '" + instruction + "' -> package '" + packageDefinition.packageName + "'");
            PackageDefinition override = instructionDefinition.packageDefinition;
            String packageName = packageDefinition.packageName;
            String version = packageDefinition.version;
            Set uses = packageDefinition.uses;
            return new PackageDefinition(packageName, override.resolutionOptional, version, uses);
        }
        return packageDefinition;
    }

    private static final class InstructionDefinition {
        private final PackageDefinition packageDefinition;
        private final Instruction instruction;

        private InstructionDefinition(PackageDefinition packageDefinition, Instruction instruction) {
            this.packageDefinition = packageDefinition;
            this.instruction = instruction;
        }

        public String toString() {
            return "InstructionDefinition{packageDefinition=" + this.packageDefinition + ", instruction=" + this.instruction + '}';
        }
    }

    private static final class PackageDefinition {
        private final String packageName;
        private final boolean resolutionOptional;
        private final String version;
        private final Set<String> uses;

        private PackageDefinition(String definition) {
            String[] tokens = definition.split(";");
            this.packageName = tokens[0];
            this.resolutionOptional = this.findResolutionConstraint(tokens);
            this.version = this.findVersionConstraint(tokens);
            this.uses = this.findUsesConstraint(tokens);
        }

        private PackageDefinition(String packageName, boolean resolutionOptional, String version, Set<String> uses) {
            this.packageName = packageName;
            this.resolutionOptional = resolutionOptional;
            this.version = version;
            this.uses = new LinkedHashSet<String>(uses);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackageDefinition that = (PackageDefinition)o;
            return !(this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null);
        }

        public int hashCode() {
            return this.packageName != null ? this.packageName.hashCode() : 0;
        }

        public String toString() {
            return "PackageDefinition{packageName='" + this.packageName + '\'' + ", resolutionOptional=" + this.resolutionOptional + ", version='" + this.version + '\'' + ", uses=" + this.uses + '}';
        }

        public String buildDefinition(boolean addResolutionConstraint) {
            StringBuilder sb = new StringBuilder(this.packageName);
            if (addResolutionConstraint && this.resolutionOptional) {
                sb.append(";").append(HazelcastManifestTransformer.RESOLUTION_PREFIX).append("optional");
            }
            if (this.version != null) {
                sb.append(";").append(HazelcastManifestTransformer.VERSION_PREFIX).append(this.version);
            }
            if (this.uses != null && !this.uses.isEmpty()) {
                sb.append(";").append(HazelcastManifestTransformer.USES_PREFIX).append('\"').append(StringUtils.join(this.uses.iterator(), (String)",")).append('\"');
            }
            return sb.toString();
        }

        private String findVersionConstraint(String[] tokens) {
            for (String token : tokens) {
                if (!token.startsWith(HazelcastManifestTransformer.VERSION_PREFIX)) continue;
                return token.substring(8);
            }
            return null;
        }

        private boolean findResolutionConstraint(String[] tokens) {
            for (String token : tokens) {
                if (!token.startsWith(HazelcastManifestTransformer.RESOLUTION_PREFIX)) continue;
                return token.equalsIgnoreCase("resolution:=optional");
            }
            return false;
        }

        private Set<String> findUsesConstraint(String[] tokens) {
            for (String token : tokens) {
                if (!token.startsWith(HazelcastManifestTransformer.USES_PREFIX)) continue;
                String packages = token.substring(7, token.length() - 1);
                Object[] sepPackages = packages.split(",");
                return new LinkedHashSet<String>(Arrays.asList((Object[])sepPackages));
            }
            return Collections.emptySet();
        }
    }
}

