/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.test.archunit;

import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

public class TestsHaveRunnersCondition
extends ArchCondition<JavaClass> {
    private static final Collection<String> SYSTEM_PROPERTY_MODIFICATION_METHODS = Set.of("java.lang.System.setProperty(java.lang.String, java.lang.String)", "java.lang.System.clearProperty(String)", "com.hazelcast.spi.properties.HazelcastProperty.setSystemProperty(java.lang.String)");

    public TestsHaveRunnersCondition() {
        super("All tests should have @RunWith annotation", new Object[0]);
    }

    public void check(JavaClass clazz, ConditionEvents events) {
        if (TestsHaveRunnersCondition.isMutatingSystemProperties(clazz) && !TestsHaveRunnersCondition.isPropertyIsolated(clazz)) {
            String message = String.format("Class %s modified system properties, but is not isolated with @RunWith annotation", clazz.getName());
            events.add(SimpleConditionEvent.violated((Object)clazz, (String)message));
        }
    }

    private static boolean isPropertyIsolated(JavaClass clazz) {
        JavaClass classToTest = clazz;
        while (classToTest.getSuperclass().isPresent()) {
            if (classToTest.isAnnotatedWith(RunWith.class) || classToTest.isAnnotatedWith(Parameterized.UseParametersRunnerFactory.class)) {
                return true;
            }
            if (classToTest.isAnnotatedWith("com.hazelcast.test.annotation.ParallelJVMTest") || classToTest.isAnnotatedWith(Category.class) && Arrays.stream(((Category)classToTest.getAnnotationOfType(Category.class)).value()).map(Class::getName).anyMatch("com.hazelcast.test.annotation.ParallelJVMTest"::equals)) {
                return true;
            }
            if (clazz.getAllMethods().stream().anyMatch(method -> Stream.of("org.junitpioneer.jupiter.SetSystemProperty", "org.junitpioneer.jupiter.RestoreSystemProperties").map(arg_0 -> ((JavaMethod)method).tryGetAnnotationOfType(arg_0)).anyMatch(Optional::isPresent))) {
                return true;
            }
            classToTest = ((JavaType)classToTest.getSuperclass().orElseThrow()).toErasure();
        }
        return false;
    }

    private static boolean isMutatingSystemProperties(JavaClass clazz) {
        return clazz.getAllMethods().stream().map(JavaCodeUnit::getMethodCallsFromSelf).flatMap(Collection::stream).map(JavaAccess::getTarget).map(AccessTarget::getFullName).anyMatch(SYSTEM_PROPERTY_MODIFICATION_METHODS::contains);
    }
}

