/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.test.archunit;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.Set;

public class OperationShouldNotImplementReadonlyAndMutatingOperation
extends ArchCondition<JavaClass> {
    private static final String READONLY_OPERATION = "com.hazelcast.spi.impl.operationservice.ReadonlyOperation";
    private static final String MUTATING_OPERATION = "com.hazelcast.spi.impl.operationservice.MutatingOperation";

    OperationShouldNotImplementReadonlyAndMutatingOperation() {
        super("not implement both com.hazelcast.spi.impl.operationservice.ReadonlyOperation and com.hazelcast.spi.impl.operationservice.MutatingOperation interfaces", new Object[0]);
    }

    public void check(JavaClass clazz, ConditionEvents events) {
        Set implementedInterfaces = clazz.getAllRawInterfaces();
        boolean implementsReadonly = implementedInterfaces.stream().anyMatch(i -> i.getName().equals(READONLY_OPERATION));
        boolean implementsMutatingOp = implementedInterfaces.stream().anyMatch(i -> i.getName().equals(MUTATING_OPERATION));
        if (implementsReadonly && implementsMutatingOp) {
            events.add(SimpleConditionEvent.violated((Object)clazz, (String)("Operation class " + clazz.getName() + " should not implement both ReadonlyOperation and MutatingOperation interfaces")));
        }
    }

    static OperationShouldNotImplementReadonlyAndMutatingOperation notImplementReadonlyAndMutatingOperation() {
        return new OperationShouldNotImplementReadonlyAndMutatingOperation();
    }
}

