/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.test.archunit;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.core.importer.ImportOption;
import java.nio.file.Paths;
import java.util.regex.Pattern;

public final class ModuleImportOptions {
    private ModuleImportOptions() {
    }

    private static String getModuleName() {
        return Paths.get("", new String[0]).toAbsolutePath().getFileName().toString();
    }

    private static ImportOption onlyCurrentModule() {
        Pattern projectModulePattern = Pattern.compile(".*/" + ModuleImportOptions.getModuleName() + "/target/classes/.*");
        return location -> location.matches(projectModulePattern);
    }

    public static JavaClasses getCurrentModuleClasses(String basePackage) {
        return new ClassFileImporter().withImportOption(ModuleImportOptions.onlyCurrentModule()).importPackages(new String[]{basePackage});
    }

    private static ImportOption onlyCurrentModuleTests() {
        Pattern projectModulePattern = Pattern.compile(".*/" + ModuleImportOptions.getModuleName() + "/target/test-classes/.*");
        return location -> location.matches(projectModulePattern);
    }

    public static JavaClasses getCurrentModuleTestClasses(String basePackage) {
        return new ClassFileImporter().withImportOption(ModuleImportOptions.onlyCurrentModuleTests()).importPackages(new String[]{basePackage});
    }
}

