/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.logical;

import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.rel.core.Filter;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalFilter;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableScan;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.util.mapping.Mapping;
import com.hazelcast.org.apache.calcite.util.mapping.Mappings;
import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import java.util.ArrayList;
import java.util.List;

public final class FilterIntoScanLogicalRule
extends RelOptRule {
    public static final FilterIntoScanLogicalRule INSTANCE = new FilterIntoScanLogicalRule();

    private FilterIntoScanLogicalRule() {
        super(FilterIntoScanLogicalRule.operand(LogicalFilter.class, FilterIntoScanLogicalRule.operandJ(LogicalTableScan.class, null, OptUtils::isHazelcastTable, FilterIntoScanLogicalRule.none()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, FilterIntoScanLogicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        TableScan scan = (TableScan)call.rel(1);
        HazelcastTable originalTable = OptUtils.getHazelcastTable(scan);
        RexNode newCondition = FilterIntoScanLogicalRule.remapCondition(originalTable, filter.getCondition());
        RexNode originalCondition = originalTable.getFilter();
        if (originalCondition != null) {
            ArrayList<RexNode> nodes = new ArrayList<RexNode>(2);
            nodes.add(originalCondition);
            nodes.add(newCondition);
            newCondition = RexUtil.composeConjunction(scan.getCluster().getRexBuilder(), nodes, true);
        }
        LogicalTableScan newScan = OptUtils.createLogicalScanWithNewTable(scan, originalTable.withFilter(newCondition));
        call.transformTo(newScan);
    }

    private static RexNode remapCondition(HazelcastTable originalHazelcastTable, RexNode originalFilterCondition) {
        List<Integer> projects = originalHazelcastTable.getProjects();
        Mapping mapping = Mappings.source(projects, originalHazelcastTable.getOriginalFieldCount());
        return RexUtil.apply((Mappings.TargetMapping)mapping, originalFilterCondition);
    }
}

