/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.hc.core5.http.nio.support;

import com.hazelcast.org.apache.hc.core5.annotation.Contract;
import com.hazelcast.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.hazelcast.org.apache.hc.core5.http.EntityDetails;
import com.hazelcast.org.apache.hc.core5.http.Header;
import com.hazelcast.org.apache.hc.core5.http.HttpException;
import com.hazelcast.org.apache.hc.core5.http.HttpRequest;
import com.hazelcast.org.apache.hc.core5.http.HttpResponse;
import com.hazelcast.org.apache.hc.core5.http.message.BasicHttpResponse;
import com.hazelcast.org.apache.hc.core5.http.nio.AsyncDataConsumer;
import com.hazelcast.org.apache.hc.core5.http.nio.AsyncEntityProducer;
import com.hazelcast.org.apache.hc.core5.http.nio.AsyncFilterChain;
import com.hazelcast.org.apache.hc.core5.http.nio.AsyncFilterHandler;
import com.hazelcast.org.apache.hc.core5.http.protocol.HttpContext;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public class AsyncServerExpectationFilter
implements AsyncFilterHandler {
    protected boolean verify(HttpRequest request, HttpContext context) throws HttpException {
        return true;
    }

    protected AsyncEntityProducer generateResponseContent(HttpResponse expectationFailed) throws HttpException {
        return null;
    }

    @Override
    public final AsyncDataConsumer handle(HttpRequest request, EntityDetails entityDetails, HttpContext context, AsyncFilterChain.ResponseTrigger responseTrigger, AsyncFilterChain chain) throws HttpException, IOException {
        Header h;
        if (entityDetails != null && (h = request.getFirstHeader("Expect")) != null && "100-continue".equalsIgnoreCase(h.getValue())) {
            boolean verified = this.verify(request, context);
            if (verified) {
                responseTrigger.sendInformation(new BasicHttpResponse(100));
            } else {
                BasicHttpResponse expectationFailed = new BasicHttpResponse(417);
                AsyncEntityProducer responseContentProducer = this.generateResponseContent(expectationFailed);
                responseTrigger.submitResponse(expectationFailed, responseContentProducer);
                return null;
            }
        }
        return chain.proceed(request, entityDetails, context, responseTrigger);
    }
}

