/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.events;

import com.hazelcast.internal.json.JsonObject;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public final class EventMetadata {
    private final EventType type;
    private final long timestamp;

    public EventMetadata(EventType type, long timestamp) {
        this.type = type;
        this.timestamp = timestamp;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("type", this.type.code);
        json.add("timestamp", this.timestamp);
        return json;
    }

    public static enum EventType {
        WAN_CONSISTENCY_CHECK_STARTED(1),
        WAN_CONSISTENCY_CHECK_FINISHED(2),
        WAN_SYNC_STARTED(3),
        WAN_SYNC_FINISHED_FULL(4),
        WAN_CONSISTENCY_CHECK_IGNORED(5),
        WAN_SYNC_PROGRESS_UPDATE(6),
        WAN_SYNC_FINISHED_MERKLE(7),
        WAN_CONFIGURATION_ADDED(8),
        ADD_WAN_CONFIGURATION_IGNORED(9),
        WAN_SYNC_IGNORED(10),
        WAN_CONFIGURATION_EXTENDED(11);

        private static final Map<Integer, EventType> CODE_MAPPING;
        private final int code;

        private EventType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static EventType withCode(int code) {
            EventType type = CODE_MAPPING.get(code);
            if (type == null) {
                throw new IllegalArgumentException("No EventType with code " + code);
            }
            return type;
        }

        public String toString() {
            return "EventType{name=" + this.name() + ", code=" + this.code + '}';
        }

        static {
            CODE_MAPPING = Arrays.stream(EventType.values()).collect(Collectors.toMap(EventType::getCode, eventType -> eventType));
        }
    }
}

