/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.materialize;

import com.hazelcast.com.google.common.cache.CacheBuilder;
import com.hazelcast.com.google.common.cache.CacheLoader;
import com.hazelcast.com.google.common.cache.LoadingCache;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.util.concurrent.UncheckedExecutionException;
import com.hazelcast.org.apache.calcite.materialize.Lattice;
import com.hazelcast.org.apache.calcite.materialize.LatticeStatisticProvider;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

class CachingLatticeStatisticProvider
implements LatticeStatisticProvider {
    private final Lattice lattice;
    private final LoadingCache<Lattice.Column, Double> cache;

    CachingLatticeStatisticProvider(Lattice lattice, LatticeStatisticProvider provider) {
        this.lattice = lattice;
        this.cache = CacheBuilder.newBuilder().build(CacheLoader.from(key -> provider.cardinality(ImmutableList.of(key))));
    }

    @Override
    public double cardinality(List<Lattice.Column> columns) {
        ArrayList<Double> counts = new ArrayList<Double>();
        for (Lattice.Column column : columns) {
            try {
                counts.add(this.cache.get(column));
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                Util.throwIfUnchecked(e.getCause());
                throw new RuntimeException(e.getCause());
            }
        }
        return (int)Lattice.getRowCount(this.lattice.getFactRowCount(), counts);
    }
}

