/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.avatica.remote;

import com.hazelcast.org.apache.calcite.avatica.ConnectionConfig;
import com.hazelcast.org.apache.calcite.avatica.remote.HostnameVerificationConfigurable;
import com.hazelcast.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import com.hazelcast.org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import com.hazelcast.org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import com.hazelcast.org.apache.hc.client5.http.ssl.HttpsSupport;
import com.hazelcast.org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import com.hazelcast.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import com.hazelcast.org.apache.hc.core5.http.config.Registry;
import com.hazelcast.org.apache.hc.core5.http.config.RegistryBuilder;
import com.hazelcast.org.apache.hc.core5.ssl.SSLContextBuilder;
import com.hazelcast.org.apache.hc.core5.ssl.SSLContexts;
import com.hazelcast.org.slf4j.Logger;
import com.hazelcast.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class CommonsHttpClientPoolCache {
    private static final String MAX_POOLED_CONNECTION_PER_ROUTE_KEY = "avatica.pooled.connections.per.route";
    private static final String MAX_POOLED_CONNECTION_PER_ROUTE_DEFAULT = "25";
    private static final String MAX_POOLED_CONNECTIONS_KEY = "avatica.pooled.connections.max";
    private static final String MAX_POOLED_CONNECTIONS_DEFAULT = "100";
    private static final Logger LOG = LoggerFactory.getLogger(CommonsHttpClientPoolCache.class);
    private static final ConcurrentHashMap<String, PoolingHttpClientConnectionManager> CACHED_POOLS = new ConcurrentHashMap();

    private CommonsHttpClientPoolCache() {
    }

    public static PoolingHttpClientConnectionManager getPool(ConnectionConfig config) {
        String sslDisc = CommonsHttpClientPoolCache.extractSSLParameters(config);
        return CACHED_POOLS.computeIfAbsent(sslDisc, k -> CommonsHttpClientPoolCache.setupPool(config));
    }

    private static PoolingHttpClientConnectionManager setupPool(ConnectionConfig config) {
        Registry<ConnectionSocketFactory> csfr = CommonsHttpClientPoolCache.createCSFRegistry(config);
        PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager(csfr);
        String maxCnxns = System.getProperty(MAX_POOLED_CONNECTIONS_KEY, MAX_POOLED_CONNECTIONS_DEFAULT);
        pool.setMaxTotal(Integer.parseInt(maxCnxns));
        String maxCnxnsPerRoute = System.getProperty(MAX_POOLED_CONNECTION_PER_ROUTE_KEY, MAX_POOLED_CONNECTION_PER_ROUTE_DEFAULT);
        pool.setDefaultMaxPerRoute(Integer.parseInt(maxCnxnsPerRoute));
        LOG.debug("Created new pool {}", (Object)pool);
        return pool;
    }

    private static Registry<ConnectionSocketFactory> createCSFRegistry(ConnectionConfig config) {
        RegistryBuilder<ConnectionSocketFactory> registryBuilder = RegistryBuilder.create();
        CommonsHttpClientPoolCache.configureHttpRegistry(registryBuilder);
        CommonsHttpClientPoolCache.configureHttpsRegistry(registryBuilder, config);
        return registryBuilder.build();
    }

    private static void configureHttpsRegistry(RegistryBuilder<ConnectionSocketFactory> registryBuilder, ConnectionConfig config) {
        try {
            SSLContext sslContext = CommonsHttpClientPoolCache.getSSLContext(config);
            HostnameVerifier verifier = CommonsHttpClientPoolCache.getHostnameVerifier(config.hostnameVerification());
            SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslContext, verifier);
            registryBuilder.register("https", sslFactory);
        }
        catch (Exception e) {
            LOG.error("HTTPS registry configuration failed");
            throw new RuntimeException(e);
        }
    }

    private static SSLContext getSSLContext(ConnectionConfig config) throws Exception {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        if (null != config.truststore() && null != config.truststorePassword()) {
            CommonsHttpClientPoolCache.loadTrustStore(sslContextBuilder, config);
        }
        if (null != config.keystore() && null != config.keystorePassword() && null != config.keyPassword()) {
            CommonsHttpClientPoolCache.loadKeyStore(sslContextBuilder, config);
        }
        return sslContextBuilder.build();
    }

    private static void loadKeyStore(SSLContextBuilder sslContextBuilder, ConnectionConfig config) throws Exception {
        sslContextBuilder.loadKeyMaterial(config.keystore(), config.keystorePassword().toCharArray(), config.keyPassword().toCharArray());
    }

    private static void loadTrustStore(SSLContextBuilder sslContextBuilder, ConnectionConfig config) throws Exception {
        sslContextBuilder.loadTrustMaterial(config.truststore(), config.truststorePassword().toCharArray());
        LOG.info("Trustore loaded from: {}", (Object)config.truststore());
    }

    private static void configureHttpRegistry(RegistryBuilder<ConnectionSocketFactory> registryBuilder) {
        registryBuilder.register("http", PlainConnectionSocketFactory.getSocketFactory());
    }

    private static HostnameVerifier getHostnameVerifier(HostnameVerificationConfigurable.HostnameVerification verification) {
        if (verification == null) {
            verification = HostnameVerificationConfigurable.HostnameVerification.STRICT;
        }
        switch (verification) {
            case STRICT: {
                return HttpsSupport.getDefaultHostnameVerifier();
            }
            case NONE: {
                return NoopHostnameVerifier.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unhandled HostnameVerification: " + verification.name());
    }

    private static String extractSSLParameters(ConnectionConfig config) {
        long keyMtime = 0L;
        if (config.keystore() != null && config.keystore().canRead()) {
            try {
                keyMtime = Files.readAttributes(config.keystore().toPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        long trustMtime = 0L;
        if (config.truststore() != null && config.truststore().canRead()) {
            try {
                trustMtime = Files.readAttributes(config.truststore().toPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(config.hostnameVerification().toString()).append(":").append(config.truststore()).append(":").append(config.truststorePassword()).append(":").append(config.keystore()).append(":").append(config.keystorePassword()).append(":").append(config.keyPassword()).append(":").append(keyMtime).append(":").append(trustMtime);
        return sb.toString();
    }
}

