/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.JavaMajorVersion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.lang.reflect.Method;

public enum JavaVersion implements JavaMajorVersion
{
    JAVA_8(8),
    JAVA_9(9),
    JAVA_10(10),
    JAVA_11(11),
    JAVA_12(12),
    JAVA_13(13),
    JAVA_14(14),
    JAVA_15(15),
    JAVA_16(16);

    private static final JavaMajorVersion CURRENT_VERSION;
    private int majorVersion;

    private JavaVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    public static boolean isAtLeast(JavaVersion version) {
        return JavaVersion.isAtLeast(CURRENT_VERSION, version);
    }

    public static boolean isAtMost(JavaVersion version) {
        return JavaVersion.isAtMost(CURRENT_VERSION, version);
    }

    static boolean isAtLeast(JavaMajorVersion currentVersion, JavaMajorVersion minVersion) {
        return currentVersion.getMajorVersion() >= minVersion.getMajorVersion();
    }

    static boolean isAtMost(JavaMajorVersion currentVersion, JavaMajorVersion maxVersion) {
        return currentVersion.getMajorVersion() <= maxVersion.getMajorVersion();
    }

    private static JavaVersion valueOf(int majorVersion) {
        for (JavaVersion version : JavaVersion.values()) {
            if (version.majorVersion != majorVersion) continue;
            return version;
        }
        return null;
    }

    private static JavaMajorVersion detectCurrentVersion() {
        Class<?> versionClass;
        ILogger logger = Logger.getLogger(JavaVersion.class);
        Class<Runtime> runtimeClass = Runtime.class;
        try {
            versionClass = Class.forName("java.lang.Runtime$Version");
        }
        catch (ClassNotFoundException e) {
            if (logger.isFineEnabled()) {
                logger.fine("Detected runtime version: Java 8");
            }
            return JAVA_8;
        }
        try {
            JavaVersion foundVersion;
            Method versionMethod = runtimeClass.getDeclaredMethod("version", new Class[0]);
            Object versionObj = versionMethod.invoke((Object)Runtime.getRuntime(), new Object[0]);
            Method majorMethod = versionClass.getDeclaredMethod("major", new Class[0]);
            int majorVersion = (Integer)majorMethod.invoke(versionObj, new Object[0]);
            if (logger.isFineEnabled()) {
                logger.fine("Detected runtime version: Java " + majorVersion);
            }
            if ((foundVersion = JavaVersion.valueOf(majorVersion)) != null) {
                return foundVersion;
            }
            return new FutureJavaVersion(majorVersion);
        }
        catch (Exception e) {
            logger.warning("Unable to detect Java version, falling back to Java 8", e);
            return JAVA_8;
        }
    }

    public static void main(String[] args) {
        System.out.println(CURRENT_VERSION.getMajorVersion());
    }

    static {
        CURRENT_VERSION = JavaVersion.detectCurrentVersion();
    }

    static class FutureJavaVersion
    implements JavaMajorVersion {
        private final int majorVersion;

        FutureJavaVersion(int majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public int getMajorVersion() {
            return this.majorVersion;
        }
    }
}

