/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.config;

import com.hazelcast.org.apache.calcite.avatica.ConnectionConfigImpl;
import com.hazelcast.org.apache.calcite.avatica.util.Casing;
import com.hazelcast.org.apache.calcite.avatica.util.Quoting;
import com.hazelcast.org.apache.calcite.config.CalciteConnectionConfig;
import com.hazelcast.org.apache.calcite.config.CalciteConnectionProperty;
import com.hazelcast.org.apache.calcite.config.Lex;
import com.hazelcast.org.apache.calcite.config.NullCollation;
import com.hazelcast.org.apache.calcite.model.JsonSchema;
import com.hazelcast.org.apache.calcite.runtime.ConsList;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorTable;
import com.hazelcast.org.apache.calcite.sql.fun.SqlLibrary;
import com.hazelcast.org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformanceEnum;
import java.util.List;
import java.util.Properties;

public class CalciteConnectionConfigImpl
extends ConnectionConfigImpl
implements CalciteConnectionConfig {
    public CalciteConnectionConfigImpl(Properties properties) {
        super(properties);
    }

    public CalciteConnectionConfigImpl set(CalciteConnectionProperty property, String value) {
        Properties newProperties = (Properties)this.properties.clone();
        newProperties.setProperty(property.camelName(), value);
        return new CalciteConnectionConfigImpl(newProperties);
    }

    public CalciteConnectionConfigImpl unset(CalciteConnectionProperty property) {
        Properties newProperties = (Properties)this.properties.clone();
        newProperties.remove(property.camelName());
        return new CalciteConnectionConfigImpl(newProperties);
    }

    public boolean isSet(CalciteConnectionProperty property) {
        return this.properties.containsKey(property.camelName());
    }

    @Override
    public boolean approximateDistinctCount() {
        return CalciteConnectionProperty.APPROXIMATE_DISTINCT_COUNT.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean approximateTopN() {
        return CalciteConnectionProperty.APPROXIMATE_TOP_N.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean approximateDecimal() {
        return CalciteConnectionProperty.APPROXIMATE_DECIMAL.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean nullEqualToEmpty() {
        return CalciteConnectionProperty.NULL_EQUAL_TO_EMPTY.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean autoTemp() {
        return CalciteConnectionProperty.AUTO_TEMP.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean materializationsEnabled() {
        return CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean createMaterializations() {
        return CalciteConnectionProperty.CREATE_MATERIALIZATIONS.wrap(this.properties).getBoolean();
    }

    @Override
    public NullCollation defaultNullCollation() {
        return CalciteConnectionProperty.DEFAULT_NULL_COLLATION.wrap(this.properties).getEnum(NullCollation.class, NullCollation.HIGH);
    }

    @Override
    public <T> T fun(Class<T> operatorTableClass, T defaultOperatorTable) {
        String fun = CalciteConnectionProperty.FUN.wrap(this.properties).getString();
        if (fun == null || fun.equals("") || fun.equals("standard")) {
            return defaultOperatorTable;
        }
        List<SqlLibrary> libraryList = SqlLibrary.parse(fun);
        SqlOperatorTable operatorTable = SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(ConsList.of(SqlLibrary.STANDARD, libraryList));
        return operatorTableClass.cast(operatorTable);
    }

    @Override
    public String model() {
        return CalciteConnectionProperty.MODEL.wrap(this.properties).getString();
    }

    @Override
    public Lex lex() {
        return CalciteConnectionProperty.LEX.wrap(this.properties).getEnum(Lex.class);
    }

    @Override
    public Quoting quoting() {
        return CalciteConnectionProperty.QUOTING.wrap(this.properties).getEnum(Quoting.class, this.lex().quoting);
    }

    @Override
    public Casing unquotedCasing() {
        return CalciteConnectionProperty.UNQUOTED_CASING.wrap(this.properties).getEnum(Casing.class, this.lex().unquotedCasing);
    }

    @Override
    public Casing quotedCasing() {
        return CalciteConnectionProperty.QUOTED_CASING.wrap(this.properties).getEnum(Casing.class, this.lex().quotedCasing);
    }

    @Override
    public boolean caseSensitive() {
        return CalciteConnectionProperty.CASE_SENSITIVE.wrap(this.properties).getBoolean(this.lex().caseSensitive);
    }

    @Override
    public <T> T parserFactory(Class<T> parserFactoryClass, T defaultParserFactory) {
        return CalciteConnectionProperty.PARSER_FACTORY.wrap(this.properties).getPlugin(parserFactoryClass, defaultParserFactory);
    }

    @Override
    public <T> T schemaFactory(Class<T> schemaFactoryClass, T defaultSchemaFactory) {
        return CalciteConnectionProperty.SCHEMA_FACTORY.wrap(this.properties).getPlugin(schemaFactoryClass, defaultSchemaFactory);
    }

    @Override
    public JsonSchema.Type schemaType() {
        return CalciteConnectionProperty.SCHEMA_TYPE.wrap(this.properties).getEnum(JsonSchema.Type.class);
    }

    @Override
    public boolean spark() {
        return CalciteConnectionProperty.SPARK.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean forceDecorrelate() {
        return CalciteConnectionProperty.FORCE_DECORRELATE.wrap(this.properties).getBoolean();
    }

    @Override
    public <T> T typeSystem(Class<T> typeSystemClass, T defaultTypeSystem) {
        return CalciteConnectionProperty.TYPE_SYSTEM.wrap(this.properties).getPlugin(typeSystemClass, defaultTypeSystem);
    }

    @Override
    public SqlConformance conformance() {
        return CalciteConnectionProperty.CONFORMANCE.wrap(this.properties).getEnum(SqlConformanceEnum.class);
    }

    @Override
    public String timeZone() {
        return CalciteConnectionProperty.TIME_ZONE.wrap(this.properties).getString();
    }

    @Override
    public String locale() {
        return CalciteConnectionProperty.LOCALE.wrap(this.properties).getString();
    }

    @Override
    public boolean typeCoercion() {
        return CalciteConnectionProperty.TYPE_COERCION.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean lenientOperatorLookup() {
        return CalciteConnectionProperty.LENIENT_OPERATOR_LOOKUP.wrap(this.properties).getBoolean();
    }
}

