/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.MapLoader;

public interface EntryLoader<K, V>
extends MapLoader<K, MetadataAwareValue<V>> {

    public static class MetadataAwareValue<V> {
        public static final long NO_TIME_SET = Long.MAX_VALUE;
        private final V value;
        private final long expirationTime;

        public MetadataAwareValue(V value) {
            this.value = Preconditions.isNotNull(value, "value");
            this.expirationTime = Long.MAX_VALUE;
        }

        public MetadataAwareValue(V value, long expirationTime) {
            this.value = Preconditions.isNotNull(value, "value");
            this.expirationTime = expirationTime;
        }

        public V getValue() {
            return this.value;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }
    }
}

