/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.CacheEventType;
import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.event.CachePartitionLostEvent;
import com.hazelcast.cache.impl.event.CachePartitionLostListener;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemovePartitionLostListenerCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import javax.cache.CacheException;
import javax.cache.integration.CompletionListener;

final class ClientCacheProxySupportUtil {
    private ClientCacheProxySupportUtil() {
    }

    static void handleFailureOnCompletionListener(CompletionListener completionListener, Throwable t) {
        if (t instanceof Exception) {
            Throwable cause = t.getCause();
            if (t instanceof ExecutionException && cause instanceof CacheException) {
                completionListener.onException((Exception)((Object)((CacheException)cause)));
            } else {
                completionListener.onException((Exception)t);
            }
        } else {
            if (t instanceof OutOfMemoryError) {
                throw ExceptionUtil.rethrow(t);
            }
            completionListener.onException((Exception)((Object)new CacheException(t)));
        }
    }

    static <T> T getSafely(Future<T> future) {
        try {
            return future.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    static <T> CompletableFuture<T> addCallback(InternalCompletableFuture<T> future, BiConsumer<T, Throwable> callback) {
        return callback == null ? future : future.whenCompleteAsync((BiConsumer)callback, ConcurrencyUtil.CALLER_RUNS);
    }

    static EventHandler createHandler(CacheEventListenerAdaptor<?, ?> adaptor) {
        return new CacheEventHandler(adaptor);
    }

    static ListenerMessageCodec createCacheEntryListenerCodec(String nameWithPrefix) {
        return new CacheEntryListenerCodec(nameWithPrefix);
    }

    static ListenerMessageCodec createPartitionLostListenerCodec(String name) {
        return new PartitionLostListenerCodec(name);
    }

    static final class ClientCachePartitionLostEventHandler
    extends CacheAddPartitionLostListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final String name;
        private final ClientContext clientContext;
        private final CachePartitionLostListener listener;

        ClientCachePartitionLostEventHandler(String name, ClientContext clientContext, CachePartitionLostListener listener) {
            this.name = name;
            this.clientContext = clientContext;
            this.listener = listener;
        }

        @Override
        public void handleCachePartitionLostEvent(int partitionId, UUID uuid) {
            Member member = this.clientContext.getClusterService().getMember(uuid);
            this.listener.partitionLost(new CachePartitionLostEvent(this.name, member, CacheEventType.PARTITION_LOST.getType(), partitionId));
        }
    }

    static final class FutureEntriesTuple {
        private final Future future;
        private final List<Map.Entry<Data, Data>> entries;

        FutureEntriesTuple(Future future, List<Map.Entry<Data, Data>> entries) {
            this.future = future;
            this.entries = entries;
        }

        public Future getFuture() {
            return this.future;
        }

        public List<Map.Entry<Data, Data>> getEntries() {
            return this.entries;
        }
    }

    static final class CacheEventHandler
    extends CacheAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final CacheEventListenerAdaptor<?, ?> adaptor;

        CacheEventHandler(CacheEventListenerAdaptor<?, ?> adaptor) {
            this.adaptor = adaptor;
        }

        @Override
        public void handleCacheEvent(int type, Collection<CacheEventData> keys, int completionId) {
            this.adaptor.handle(type, keys, completionId);
        }
    }

    static class EmptyCompletionListener
    implements CompletionListener {
        EmptyCompletionListener() {
        }

        public void onCompletion() {
        }

        public void onException(Exception e) {
        }
    }

    static class PartitionLostListenerCodec
    implements ListenerMessageCodec {
        private final String name;

        PartitionLostListenerCodec(String name) {
            this.name = name;
        }

        @Override
        public ClientMessage encodeAddRequest(boolean localOnly) {
            return CacheAddPartitionLostListenerCodec.encodeRequest(this.name, localOnly);
        }

        @Override
        public UUID decodeAddResponse(ClientMessage clientMessage) {
            return CacheAddPartitionLostListenerCodec.decodeResponse(clientMessage);
        }

        @Override
        public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
            return CacheRemovePartitionLostListenerCodec.encodeRequest(this.name, realRegistrationId);
        }

        @Override
        public boolean decodeRemoveResponse(ClientMessage clientMessage) {
            return CacheRemovePartitionLostListenerCodec.decodeResponse(clientMessage);
        }
    }

    static class CacheEntryListenerCodec
    implements ListenerMessageCodec {
        private final String nameWithPrefix;

        CacheEntryListenerCodec(String nameWithPrefix) {
            this.nameWithPrefix = nameWithPrefix;
        }

        @Override
        public ClientMessage encodeAddRequest(boolean localOnly) {
            return CacheAddEntryListenerCodec.encodeRequest(this.nameWithPrefix, localOnly);
        }

        @Override
        public UUID decodeAddResponse(ClientMessage clientMessage) {
            return CacheAddEntryListenerCodec.decodeResponse(clientMessage);
        }

        @Override
        public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
            return CacheRemoveEntryListenerCodec.encodeRequest(this.nameWithPrefix, realRegistrationId);
        }

        @Override
        public boolean decodeRemoveResponse(ClientMessage clientMessage) {
            return CacheRemoveEntryListenerCodec.decodeResponse(clientMessage);
        }
    }
}

