/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators;

import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.fun.SqlLikeOperator;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserUtil;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastOperandTypes;
import com.hazelcast.sql.impl.calcite.validate.types.ReplaceUnknownOperandTypeInference;

public class HazelcastSqlLikeOperator
extends SqlSpecialOperator {
    private static final int PRECEDENCE = 32;

    public HazelcastSqlLikeOperator() {
        super("LIKE", SqlKind.LIKE, 32, false, ReturnTypes.BOOLEAN_NULLABLE, (SqlOperandTypeInference)new ReplaceUnknownOperandTypeInference(SqlTypeName.VARCHAR), null);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 3);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        int operandCount = callBinding.getOperandCount();
        assert (operandCount == 2 || operandCount == 3);
        SqlSingleOperandTypeChecker operandTypeChecker = operandCount == 2 ? OperandTypes.STRING_SAME_SAME : OperandTypes.STRING_SAME_SAME_SAME;
        if (!(operandTypeChecker = HazelcastOperandTypes.notAny(operandTypeChecker)).checkOperandTypes(callBinding, throwOnFailure)) {
            return false;
        }
        return SqlTypeUtil.isCharTypeComparable(callBinding, callBinding.operands(), throwOnFailure);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        ((SqlNode)call.operand(0)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        writer.sep(this.getName());
        ((SqlNode)call.operand(1)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        if (call.operandCount() == 3) {
            writer.sep("ESCAPE");
            ((SqlNode)call.operand(2)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        }
        writer.endList(frame);
    }

    @Override
    public SqlSpecialOperator.ReduceResult reduceExpr(int opOrdinal, SqlSpecialOperator.TokenSequence list) {
        int end;
        SqlNode[] operands;
        SqlOperator op2;
        SqlNode exp0 = list.node(opOrdinal - 1);
        SqlOperator op = list.op(opOrdinal);
        assert (op instanceof SqlLikeOperator);
        SqlNode exp1 = SqlParserUtil.toTreeEx(list, opOrdinal + 1, this.getRightPrec(), SqlKind.ESCAPE);
        SqlNode exp2 = null;
        if (opOrdinal + 2 < list.size() && list.isOp(opOrdinal + 2) && (op2 = list.op(opOrdinal + 2)).getKind() == SqlKind.ESCAPE) {
            exp2 = SqlParserUtil.toTreeEx(list, opOrdinal + 3, this.getRightPrec(), SqlKind.ESCAPE);
        }
        if (exp2 != null) {
            operands = new SqlNode[]{exp0, exp1, exp2};
            end = opOrdinal + 4;
        } else {
            operands = new SqlNode[]{exp0, exp1};
            end = opOrdinal + 2;
        }
        SqlCall call = this.createCall(SqlParserPos.ZERO, operands);
        return new SqlSpecialOperator.ReduceResult(this, opOrdinal - 1, end, call);
    }
}

