/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.AbstractSqlResult;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.SqlRowImpl;
import com.hazelcast.sql.impl.plan.Plan;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.state.QueryInitiatorState;
import com.hazelcast.sql.impl.state.QueryState;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SqlResultImpl
extends AbstractSqlResult {
    private final QueryState state;
    private final SqlRowMetadata rowMetadata;
    private ResultIterator<SqlRow> iterator;
    private final long updateCount;

    private SqlResultImpl(QueryState state, long updateCount) {
        this.state = state;
        this.updateCount = updateCount;
        assert (updateCount >= 0L ^ state != null) : "updateCount=" + updateCount + ", state=" + state;
        this.rowMetadata = state != null ? state.getInitiatorState().getRowMetadata() : null;
    }

    public static SqlResultImpl createRowsResult(QueryState state) {
        return new SqlResultImpl(state, -1L);
    }

    public static SqlResultImpl createUpdateCountResult(long updateCount) {
        Preconditions.checkNotNegative(updateCount, "the updateCount must be >= 0");
        return new SqlResultImpl(null, updateCount);
    }

    @Override
    @Nonnull
    public SqlRowMetadata getRowMetadata() {
        this.checkIsRowsResult();
        return this.rowMetadata;
    }

    @Override
    @Nonnull
    public ResultIterator<SqlRow> iterator() {
        this.checkIsRowsResult();
        if (this.iterator == null) {
            this.iterator = new RowToSqlRowIterator(this.getQueryInitiatorState().getResultProducer().iterator());
            return this.iterator;
        }
        throw new IllegalStateException("Iterator can be requested only once.");
    }

    @Override
    public long updateCount() {
        return this.updateCount;
    }

    private void checkIsRowsResult() {
        if (this.updateCount >= 0L) {
            throw new IllegalStateException("This result contains only update count");
        }
    }

    @Override
    public void close(@Nullable QueryException error) {
        if (this.state != null) {
            this.state.cancel(error, false);
        }
    }

    @Override
    @Nullable
    public QueryId getQueryId() {
        this.checkIsRowsResult();
        return this.getQueryInitiatorState().getQueryId();
    }

    public Plan getPlan() {
        QueryInitiatorState initiatorState = this.getQueryInitiatorState();
        return initiatorState != null ? initiatorState.getPlan() : null;
    }

    private QueryInitiatorState getQueryInitiatorState() {
        return this.state.getInitiatorState();
    }

    private final class RowToSqlRowIterator
    implements ResultIterator<SqlRow> {
        private final ResultIterator<Row> delegate;

        private RowToSqlRowIterator(ResultIterator<Row> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (Exception e) {
                throw QueryUtils.toPublicException(e, SqlResultImpl.this.state.getLocalMemberId());
            }
        }

        @Override
        public ResultIterator.HasNextResult hasNext(long timeout, TimeUnit timeUnit) {
            try {
                return this.delegate.hasNext(timeout, timeUnit);
            }
            catch (Exception e) {
                throw QueryUtils.toPublicException(e, SqlResultImpl.this.state.getLocalMemberId());
            }
        }

        @Override
        public SqlRow next() {
            try {
                return new SqlRowImpl(SqlResultImpl.this.rowMetadata, (Row)this.delegate.next());
            }
            catch (NoSuchElementException e) {
                throw e;
            }
            catch (Exception e) {
                throw QueryUtils.toPublicException(e, SqlResultImpl.this.state.getLocalMemberId());
            }
        }
    }
}

