/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.util;

import com.hazelcast.org.apache.calcite.util.ConversionUtil;
import com.hazelcast.org.apache.calcite.util.Util;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public class BitString {
    private final String bits;
    private final int bitCount;

    protected BitString(String bits, int bitCount) {
        assert (bits.replace("1", "").replace("0", "").length() == 0) : "bit string '" + bits + "' contains digits other than {0, 1}";
        this.bits = bits;
        this.bitCount = bitCount;
    }

    public static BitString createFromHexString(String s) {
        int bitCount = s.length() * 4;
        String bits = bitCount == 0 ? "" : new BigInteger(s, 16).toString(2);
        return new BitString(bits, bitCount);
    }

    public static BitString createFromBitString(String s) {
        int n = s.length();
        if (n > 0) {
            Util.discard(new BigInteger(s, 2));
        }
        return new BitString(s, n);
    }

    public String toString() {
        return this.toBitString();
    }

    public int hashCode() {
        return this.bits.hashCode() + this.bitCount;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof BitString && this.bits.equals(((BitString)o).bits) && this.bitCount == ((BitString)o).bitCount;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public byte[] getAsByteArray() {
        return BitString.toByteArrayFromBitString(this.bits, this.bitCount);
    }

    public String toBitString() {
        return this.bits;
    }

    public String toHexString() {
        byte[] bytes = this.getAsByteArray();
        String s = ConversionUtil.toStringFromByteArray(bytes, 16);
        switch (this.bitCount % 8) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return s.substring(1);
            }
            case 0: 
            case 5: 
            case 6: 
            case 7: {
                return s;
            }
        }
        if (this.bitCount % 8 == 4) {
            return s.substring(1);
        }
        return s;
    }

    public static byte[] toByteArrayFromBitString(String bits, int bitCount) {
        byte[] srcBytes;
        if (bitCount < 0) {
            return new byte[0];
        }
        int byteCount = (bitCount + 7) / 8;
        if (bits.length() > 0) {
            BigInteger bigInt = new BigInteger(bits, 2);
            srcBytes = bigInt.toByteArray();
        } else {
            srcBytes = new byte[]{};
        }
        byte[] dest = new byte[byteCount];
        int bytesToCopy = Math.min(byteCount, srcBytes.length);
        System.arraycopy(srcBytes, srcBytes.length - bytesToCopy, dest, dest.length - bytesToCopy, bytesToCopy);
        return dest;
    }

    public static BitString concat(List<BitString> args) {
        if (args.size() < 2) {
            return args.get(0);
        }
        int length = 0;
        for (BitString arg : args) {
            length += arg.bitCount;
        }
        StringBuilder sb = new StringBuilder(length);
        for (BitString arg1 : args) {
            sb.append(arg1.bits);
        }
        return new BitString(sb.toString(), length);
    }

    public static BitString createFromBytes(byte[] bytes) {
        int bitCount = Objects.requireNonNull(bytes).length * 8;
        StringBuilder sb = new StringBuilder(bitCount);
        for (byte b : bytes) {
            String s = Integer.toBinaryString(Byte.toUnsignedInt(b));
            for (int i = s.length(); i < 8; ++i) {
                sb.append('0');
            }
            sb.append(s);
        }
        return new BitString(sb.toString(), bitCount);
    }
}

