/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.Collection;

public class PublishCompletedMigrationsOperation
extends AbstractPartitionOperation
implements MigrationCycleOperation {
    private Collection<MigrationInfo> completedMigrations;
    private transient boolean success;

    public PublishCompletedMigrationsOperation() {
    }

    public PublishCompletedMigrationsOperation(Collection<MigrationInfo> completedMigrations) {
        this.completedMigrations = completedMigrations;
    }

    @Override
    public void run() {
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        Version version = this.getNodeEngine().getClusterService().getClusterVersion();
        this.success = version.isGreaterOrEqual(Versions.V4_1) ? service.applyCompletedMigrations(this.completedMigrations, this.getCallerAddress()) : service.applyCompletedMigrationsLegacy(this.completedMigrations, this.getCallerAddress());
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.completedMigrations = SerializationUtil.readCollection(in);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        SerializationUtil.writeCollection(this.completedMigrations, out);
    }

    @Override
    public int getClassId() {
        return 20;
    }
}

