/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;

public class RingbufferConfig
implements IdentifiedDataSerializable,
NamedConfig {
    public static final int DEFAULT_CAPACITY = 10000;
    public static final int DEFAULT_SYNC_BACKUP_COUNT = 1;
    public static final int DEFAULT_ASYNC_BACKUP_COUNT = 0;
    public static final int DEFAULT_TTL_SECONDS = 0;
    public static final InMemoryFormat DEFAULT_IN_MEMORY_FORMAT = InMemoryFormat.BINARY;
    private String name;
    private int capacity = 10000;
    private int backupCount = 1;
    private int asyncBackupCount = 0;
    private int timeToLiveSeconds = 0;
    private InMemoryFormat inMemoryFormat = DEFAULT_IN_MEMORY_FORMAT;
    private RingbufferStoreConfig ringbufferStoreConfig = new RingbufferStoreConfig().setEnabled(false);
    private String splitBrainProtectionName;
    private MergePolicyConfig mergePolicyConfig = new MergePolicyConfig();

    public RingbufferConfig() {
    }

    public RingbufferConfig(String name) {
        this.name = Preconditions.checkNotNull(name, "name can't be null");
    }

    public RingbufferConfig(RingbufferConfig config) {
        Preconditions.checkNotNull(config, "config can't be null");
        this.name = config.name;
        this.capacity = config.capacity;
        this.backupCount = config.backupCount;
        this.asyncBackupCount = config.asyncBackupCount;
        this.timeToLiveSeconds = config.timeToLiveSeconds;
        this.inMemoryFormat = config.inMemoryFormat;
        if (config.ringbufferStoreConfig != null) {
            this.ringbufferStoreConfig = new RingbufferStoreConfig(config.ringbufferStoreConfig);
        }
        this.mergePolicyConfig = config.mergePolicyConfig;
        this.splitBrainProtectionName = config.splitBrainProtectionName;
    }

    public RingbufferConfig(String name, RingbufferConfig config) {
        this(config);
        this.name = Preconditions.checkNotNull(name, "name can't be null");
    }

    @Override
    public RingbufferConfig setName(String name) {
        this.name = Preconditions.checkHasText(name, "name must contain text");
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public RingbufferConfig setCapacity(int capacity) {
        this.capacity = Preconditions.checkPositive("capacity", capacity);
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public RingbufferConfig setBackupCount(int backupCount) {
        this.backupCount = Preconditions.checkBackupCount(backupCount, this.asyncBackupCount);
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public RingbufferConfig setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = Preconditions.checkAsyncBackupCount(this.backupCount, asyncBackupCount);
        return this;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public RingbufferConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = Preconditions.checkNotNegative(timeToLiveSeconds, "timeToLiveSeconds can't be smaller than 0");
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public RingbufferConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        Preconditions.checkNotNull(inMemoryFormat, "inMemoryFormat can't be null");
        Preconditions.checkFalse(inMemoryFormat == InMemoryFormat.NATIVE, "InMemoryFormat " + (Object)((Object)InMemoryFormat.NATIVE) + " is not supported");
        this.inMemoryFormat = inMemoryFormat;
        return this;
    }

    public RingbufferStoreConfig getRingbufferStoreConfig() {
        return this.ringbufferStoreConfig;
    }

    public RingbufferConfig setRingbufferStoreConfig(RingbufferStoreConfig ringbufferStoreConfig) {
        this.ringbufferStoreConfig = ringbufferStoreConfig;
        return this;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public RingbufferConfig setSplitBrainProtectionName(String splitBrainProtectionName) {
        this.splitBrainProtectionName = splitBrainProtectionName;
        return this;
    }

    public MergePolicyConfig getMergePolicyConfig() {
        return this.mergePolicyConfig;
    }

    public RingbufferConfig setMergePolicyConfig(MergePolicyConfig mergePolicyConfig) {
        this.mergePolicyConfig = mergePolicyConfig;
        return this;
    }

    public String toString() {
        return "RingbufferConfig{name='" + this.name + '\'' + ", capacity=" + this.capacity + ", backupCount=" + this.backupCount + ", asyncBackupCount=" + this.asyncBackupCount + ", timeToLiveSeconds=" + this.timeToLiveSeconds + ", inMemoryFormat=" + (Object)((Object)this.inMemoryFormat) + ", ringbufferStoreConfig=" + this.ringbufferStoreConfig + ", splitBrainProtectionName=" + this.splitBrainProtectionName + ", mergePolicyConfig=" + this.mergePolicyConfig + '}';
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 34;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.capacity);
        out.writeInt(this.backupCount);
        out.writeInt(this.asyncBackupCount);
        out.writeInt(this.timeToLiveSeconds);
        out.writeUTF(this.inMemoryFormat.name());
        out.writeObject(this.ringbufferStoreConfig);
        out.writeUTF(this.splitBrainProtectionName);
        out.writeObject(this.mergePolicyConfig);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.capacity = in.readInt();
        this.backupCount = in.readInt();
        this.asyncBackupCount = in.readInt();
        this.timeToLiveSeconds = in.readInt();
        this.inMemoryFormat = InMemoryFormat.valueOf(in.readUTF());
        this.ringbufferStoreConfig = (RingbufferStoreConfig)in.readObject();
        this.splitBrainProtectionName = in.readUTF();
        this.mergePolicyConfig = (MergePolicyConfig)in.readObject();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RingbufferConfig)) {
            return false;
        }
        RingbufferConfig that = (RingbufferConfig)o;
        return this.capacity == that.capacity && this.backupCount == that.backupCount && this.asyncBackupCount == that.asyncBackupCount && this.timeToLiveSeconds == that.timeToLiveSeconds && Objects.equals(this.name, that.name) && this.inMemoryFormat == that.inMemoryFormat && Objects.equals(this.ringbufferStoreConfig, that.ringbufferStoreConfig) && Objects.equals(this.splitBrainProtectionName, that.splitBrainProtectionName) && Objects.equals(this.mergePolicyConfig, that.mergePolicyConfig);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.name, this.capacity, this.backupCount, this.asyncBackupCount, this.timeToLiveSeconds, this.inMemoryFormat, this.ringbufferStoreConfig, this.splitBrainProtectionName, this.mergePolicyConfig});
    }
}

